/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.fieldcomparator;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.comparators.IntComparator;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.fieldcomparator.LongValuesComparatorSource;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.sort.BucketedSort;
import org.elasticsearch.search.sort.SortOrder;

public class IntValuesComparatorSource
extends LongValuesComparatorSource {
    public IntValuesComparatorSource(IndexNumericFieldData indexFieldData, @Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, IndexNumericFieldData.NumericType targetNumericType) {
        super(indexFieldData, missingValue, sortMode, nested, null, targetNumericType);
    }

    @Override
    public SortField.Type reducedType() {
        return SortField.Type.INT;
    }

    @Override
    public FieldComparator<?> newComparator(String fieldname, int numHits, Pruning enableSkipping, boolean reversed) {
        assert (this.indexFieldData == null || fieldname.equals(this.indexFieldData.getFieldName()));
        final int iMissingValue = (Integer)this.missingObject(this.missingValue, reversed);
        return new IntComparator(numHits, fieldname, null, reversed, enableSkipping){

            @Override
            public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
                return new IntComparator.IntLeafComparator(context){

                    @Override
                    protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field) throws IOException {
                        return IntValuesComparatorSource.this.getNumericDocValues(context, iMissingValue);
                    }
                };
            }
        };
    }

    @Override
    public BucketedSort newBucketedSort(BigArrays bigArrays, final SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
        return new BucketedSort.ForInts(bigArrays, sortOrder, format, bucketSize, extra){
            private final int iMissingValue;
            {
                super(bigArrays, sortOrder3, format, bucketSize, extra);
                this.iMissingValue = (Integer)IntValuesComparatorSource.this.missingObject(IntValuesComparatorSource.this.missingValue, sortOrder == SortOrder.DESC);
            }

            @Override
            public BucketedSort.ForInts.Leaf forLeaf(final LeafReaderContext ctx) throws IOException {
                return new BucketedSort.ForInts.Leaf(ctx){
                    private final NumericDocValues docValues;
                    private int docValue;
                    {
                        super(ctx2);
                        this.docValues = IntValuesComparatorSource.this.getNumericDocValues(ctx, iMissingValue);
                    }

                    @Override
                    protected boolean advanceExact(int doc) throws IOException {
                        if (this.docValues.advanceExact(doc)) {
                            this.docValue = (int)this.docValues.longValue();
                            return true;
                        }
                        return false;
                    }

                    @Override
                    protected int docValue() {
                        return this.docValue;
                    }
                };
            }
        };
    }
}

