/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexSettings;

public class DataStreamFailureStoreDefinition {
    public static final String FAILURE_STORE_REFRESH_INTERVAL_SETTING_NAME = "data_streams.failure_store.refresh_interval";
    public static final String INDEX_FAILURE_STORE_VERSION_SETTING_NAME = "index.failure_store.version";
    public static final Settings DATA_STREAM_FAILURE_STORE_SETTINGS;
    public static final Set<String> SUPPORTED_USER_SETTINGS;
    public static final Set<String> SUPPORTED_USER_SETTINGS_PREFIXES;
    public static final CompressedXContent DATA_STREAM_FAILURE_STORE_MAPPING;
    public static final int FAILURE_STORE_DEFINITION_VERSION = 1;
    public static final Setting<Integer> FAILURE_STORE_DEFINITION_VERSION_SETTING;

    public static TimeValue getFailureStoreRefreshInterval(Settings settings) {
        return settings.getAsTime(FAILURE_STORE_REFRESH_INTERVAL_SETTING_NAME, null);
    }

    public static Settings buildFailureStoreIndexSettings(Settings nodeSettings) {
        TimeValue refreshInterval = DataStreamFailureStoreDefinition.getFailureStoreRefreshInterval(nodeSettings);
        if (refreshInterval != null) {
            return Settings.builder().put(DATA_STREAM_FAILURE_STORE_SETTINGS).put(IndexSettings.INDEX_REFRESH_INTERVAL_SETTING.getKey(), refreshInterval).build();
        }
        return DATA_STREAM_FAILURE_STORE_SETTINGS;
    }

    public static Settings.Builder applyFailureStoreSettings(Settings nodeSettings, Settings.Builder builder) {
        TimeValue refreshInterval = DataStreamFailureStoreDefinition.getFailureStoreRefreshInterval(nodeSettings);
        if (refreshInterval != null) {
            builder.put(IndexSettings.INDEX_REFRESH_INTERVAL_SETTING.getKey(), refreshInterval);
        }
        return builder;
    }

    public static Settings.Builder filterUserDefinedSettings(Settings.Builder builder) {
        if (!builder.keys().isEmpty()) {
            HashSet<String> existingKeys = new HashSet<String>(builder.keys());
            for (String setting : existingKeys) {
                if (SUPPORTED_USER_SETTINGS.contains(setting)) continue;
                if (SUPPORTED_USER_SETTINGS_PREFIXES.stream().anyMatch(setting::startsWith)) continue;
                builder.remove(setting);
            }
        }
        return builder;
    }

    static {
        SUPPORTED_USER_SETTINGS = Set.of("index.routing.allocation.include._tier_preference", "index.hidden", INDEX_FAILURE_STORE_VERSION_SETTING_NAME, "index.number_of_shards", "index.number_of_replicas", "index.auto_expand_replicas", IndexSettings.INDEX_REFRESH_INTERVAL_SETTING.getKey());
        SUPPORTED_USER_SETTINGS_PREFIXES = Set.of("index.routing.allocation.require.", "index.routing.allocation.include.", "index.routing.allocation.exclude.");
        FAILURE_STORE_DEFINITION_VERSION_SETTING = Setting.intSetting(INDEX_FAILURE_STORE_VERSION_SETTING_NAME, 0, Setting.Property.IndexScope);
        DATA_STREAM_FAILURE_STORE_SETTINGS = Settings.builder().put("index.hidden", true).put(FAILURE_STORE_DEFINITION_VERSION_SETTING.getKey(), 1).build();
        try {
            DATA_STREAM_FAILURE_STORE_MAPPING = new CompressedXContent((builder, params) -> builder.startObject("_doc").field("dynamic", false).startObject("_routing").field("required", false).endObject().startObject("properties").startObject("@timestamp").field("type", "date").field("ignore_malformed", false).endObject().startObject("document").startObject("properties").startObject("id").field("type", "keyword").endObject().startObject("routing").field("type", "keyword").endObject().startObject("index").field("type", "keyword").endObject().endObject().endObject().startObject("error").startObject("properties").startObject("message").field("type", "match_only_text").endObject().startObject("stack_trace").field("type", "text").endObject().startObject("type").field("type", "keyword").endObject().startObject("pipeline").field("type", "keyword").endObject().startObject("pipeline_trace").field("type", "keyword").endObject().startObject("processor_tag").field("type", "keyword").endObject().startObject("processor_type").field("type", "keyword").endObject().endObject().endObject().endObject().endObject());
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }
}

