/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import java.io.IOException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public record Join(DiscoveryNode votingNode, DiscoveryNode masterCandidateNode, long term, long lastAcceptedTerm, long lastAcceptedVersion) implements Writeable
{
    public Join {
        assert (term >= 0L);
        assert (lastAcceptedTerm >= 0L);
        assert (lastAcceptedVersion >= 0L);
    }

    public Join(StreamInput in) throws IOException {
        this(new DiscoveryNode(in), new DiscoveryNode(in), in.readLong(), in.readLong(), in.readLong());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.votingNode.writeTo(out);
        this.masterCandidateNode.writeTo(out);
        out.writeLong(this.term);
        out.writeLong(this.lastAcceptedTerm);
        out.writeLong(this.lastAcceptedVersion);
    }

    public boolean masterCandidateMatches(DiscoveryNode matchingNode) {
        return this.masterCandidateNode.getId().equals(matchingNode.getId());
    }
}

