/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.cluster.ClusterInfo;
import org.elasticsearch.cluster.DiskUsage;
import org.elasticsearch.cluster.EstimatedHeapUsage;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.routing.ExpectedShardSizeEstimator;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.common.util.CopyOnFirstWriteMap;
import org.elasticsearch.index.shard.ShardId;

public class ClusterInfoSimulator {
    private final RoutingAllocation allocation;
    private final Map<String, DiskUsage> leastAvailableSpaceUsage;
    private final Map<String, DiskUsage> mostAvailableSpaceUsage;
    private final CopyOnFirstWriteMap<String, Long> shardSizes;
    private final Map<ShardId, Long> shardDataSetSizes;
    private final Map<ClusterInfo.NodeAndShard, String> dataPath;
    private final Map<String, EstimatedHeapUsage> estimatedHeapUsages;

    public ClusterInfoSimulator(RoutingAllocation allocation) {
        this.allocation = allocation;
        this.leastAvailableSpaceUsage = ClusterInfoSimulator.getAdjustedDiskSpace(allocation, allocation.clusterInfo().getNodeLeastAvailableDiskUsages());
        this.mostAvailableSpaceUsage = ClusterInfoSimulator.getAdjustedDiskSpace(allocation, allocation.clusterInfo().getNodeMostAvailableDiskUsages());
        this.shardSizes = new CopyOnFirstWriteMap<String, Long>(allocation.clusterInfo().shardSizes);
        this.shardDataSetSizes = Map.copyOf(allocation.clusterInfo().shardDataSetSizes);
        this.dataPath = Map.copyOf(allocation.clusterInfo().dataPath);
        this.estimatedHeapUsages = allocation.clusterInfo().getEstimatedHeapUsages();
    }

    private static Map<String, DiskUsage> getAdjustedDiskSpace(RoutingAllocation allocation, Map<String, DiskUsage> diskUsage) {
        HashMap<String, DiskUsage> diskUsageCopy = new HashMap<String, DiskUsage>(diskUsage);
        for (Map.Entry<String, DiskUsage> entry : diskUsageCopy.entrySet()) {
            RoutingNode node;
            String nodeId = entry.getKey();
            DiskUsage usage = entry.getValue();
            ClusterInfo.ReservedSpace reserved = allocation.clusterInfo().getReservedSpace(nodeId, usage.path());
            if (reserved.total() == 0L || (node = allocation.routingNodes().node(nodeId)) == null) continue;
            long adjustment = 0L;
            for (ShardId shardId : reserved.shardIds()) {
                ShardRouting shard = node.getByShardId(shardId);
                if (shard == null) continue;
                long expectedSize = ExpectedShardSizeEstimator.getExpectedShardSize(shard, 0L, allocation);
                adjustment += expectedSize;
            }
            entry.setValue(ClusterInfoSimulator.updateWithFreeBytes(usage, adjustment -= reserved.total()));
        }
        return diskUsageCopy;
    }

    public void simulateShardStarted(ShardRouting shard) {
        assert (shard.initializing());
        ProjectMetadata project = this.allocation.metadata().projectFor(shard.index());
        long size = ExpectedShardSizeEstimator.getExpectedShardSize(shard, shard.getExpectedShardSize(), this.getClusterInfo(), this.allocation.snapshotShardSizeInfo(), project, this.allocation.routingTable(project.id()));
        if (size != -1L) {
            if (shard.relocatingNodeId() != null) {
                this.modifyDiskUsage(shard.relocatingNodeId(), size);
                this.modifyDiskUsage(shard.currentNodeId(), -size);
            } else {
                if (ExpectedShardSizeEstimator.shouldReserveSpaceForInitializingShard(shard, this.allocation.metadata())) {
                    this.modifyDiskUsage(shard.currentNodeId(), -size);
                }
                this.shardSizes.put(ClusterInfo.shardIdentifierFromRouting(shard), project.getIndexSafe(shard.index()).ignoreDiskWatermarks() ? 0L : size);
            }
        }
    }

    private void modifyDiskUsage(String nodeId, long freeDelta) {
        if (freeDelta == 0L) {
            return;
        }
        DiskUsage diskUsage = this.mostAvailableSpaceUsage.get(nodeId);
        if (diskUsage == null) {
            return;
        }
        String path = diskUsage.path();
        this.updateDiskUsage(this.leastAvailableSpaceUsage, nodeId, path, freeDelta);
        this.updateDiskUsage(this.mostAvailableSpaceUsage, nodeId, path, freeDelta);
    }

    private void updateDiskUsage(Map<String, DiskUsage> availableSpaceUsage, String nodeId, String path, long freeDelta) {
        DiskUsage usage = availableSpaceUsage.get(nodeId);
        if (usage != null && Objects.equals(usage.path(), path)) {
            availableSpaceUsage.put(nodeId, ClusterInfoSimulator.updateWithFreeBytes(usage, freeDelta));
        }
    }

    private static DiskUsage updateWithFreeBytes(DiskUsage usage, long delta) {
        long freeBytes = ClusterInfoSimulator.withinRange(0L, usage.totalBytes(), usage.freeBytes() + delta);
        return usage.copyWithFreeBytes(freeBytes);
    }

    private static long withinRange(long min, long max, long value) {
        return Math.max(min, Math.min(max, value));
    }

    public ClusterInfo getClusterInfo() {
        return new ClusterInfo(this.leastAvailableSpaceUsage, this.mostAvailableSpaceUsage, this.shardSizes.toImmutableMap(), this.shardDataSetSizes, this.dataPath, Map.of(), this.estimatedHeapUsages);
    }
}

