/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.internal;

import java.util.function.Supplier;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.FilterClient;
import org.elasticsearch.common.util.concurrent.ThreadContext;

public final class OriginSettingClient
extends FilterClient {
    private final String origin;

    public OriginSettingClient(Client in, String origin) {
        super(in);
        this.origin = origin;
    }

    @Override
    protected <Request extends ActionRequest, Response extends ActionResponse> void doExecute(ActionType<Response> action, Request request, ActionListener<Response> listener) {
        Supplier<ThreadContext.StoredContext> supplier = this.in().threadPool().getThreadContext().newRestorableContext(false);
        try (ThreadContext.StoredContext ignore = this.in().threadPool().getThreadContext().stashWithOrigin(this.origin);){
            super.doExecute(action, request, new ContextPreservingActionListener<Response>(supplier, listener));
        }
    }
}

