/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.Base64;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.search.SearchResponseSections;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.DelayableWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.SimpleRefCounted;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestActions;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.profile.SearchProfileResults;
import org.elasticsearch.search.profile.SearchProfileShardResult;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.transport.LeakTracker;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class SearchResponse
extends ActionResponse
implements ChunkedToXContentObject {
    public static final String LOCAL_CLUSTER_NAME_REPRESENTATION = "(local)";
    public static final ParseField SCROLL_ID = new ParseField("_scroll_id", new String[0]);
    public static final ParseField POINT_IN_TIME_ID = new ParseField("pit_id", new String[0]);
    public static final ParseField TOOK = new ParseField("took", new String[0]);
    public static final ParseField TIMED_OUT = new ParseField("timed_out", new String[0]);
    public static final ParseField TERMINATED_EARLY = new ParseField("terminated_early", new String[0]);
    public static final ParseField NUM_REDUCE_PHASES = new ParseField("num_reduce_phases", new String[0]);
    private final SearchHits hits;
    private final InternalAggregations aggregations;
    private final Suggest suggest;
    private final SearchProfileResults profileResults;
    private final boolean timedOut;
    private final Boolean terminatedEarly;
    private final int numReducePhases;
    private final String scrollId;
    private final BytesReference pointInTimeId;
    private final int totalShards;
    private final int successfulShards;
    private final int skippedShards;
    private final ShardSearchFailure[] shardFailures;
    private final Clusters clusters;
    private final long tookInMillis;
    private final RefCounted refCounted = LeakTracker.wrap(new SimpleRefCounted());

    public SearchResponse(StreamInput in) throws IOException {
        this.hits = SearchHits.readFrom(in, true);
        this.aggregations = in.readBoolean() ? InternalAggregations.readFrom(DelayableWriteable.wrapWithDeduplicatorStreamInput(in, in.getTransportVersion(), in.namedWriteableRegistry())) : null;
        this.suggest = in.readBoolean() ? new Suggest(in) : null;
        this.timedOut = in.readBoolean();
        this.terminatedEarly = in.readOptionalBoolean();
        this.profileResults = in.readOptionalWriteable(SearchProfileResults::new);
        this.numReducePhases = in.readVInt();
        this.totalShards = in.readVInt();
        this.successfulShards = in.readVInt();
        int size = in.readVInt();
        if (size == 0) {
            this.shardFailures = ShardSearchFailure.EMPTY_ARRAY;
        } else {
            this.shardFailures = new ShardSearchFailure[size];
            for (int i = 0; i < this.shardFailures.length; ++i) {
                this.shardFailures[i] = ShardSearchFailure.readShardSearchFailure(in);
            }
        }
        this.clusters = new Clusters(in);
        this.scrollId = in.readOptionalString();
        this.tookInMillis = in.readVLong();
        this.skippedShards = in.readVInt();
        this.pointInTimeId = in.readOptionalBytesReference();
    }

    public SearchResponse(SearchHits hits, InternalAggregations aggregations, Suggest suggest, boolean timedOut, Boolean terminatedEarly, SearchProfileResults profileResults, int numReducePhases, String scrollId, int totalShards, int successfulShards, int skippedShards, long tookInMillis, ShardSearchFailure[] shardFailures, Clusters clusters) {
        this(hits, aggregations, suggest, timedOut, terminatedEarly, profileResults, numReducePhases, scrollId, totalShards, successfulShards, skippedShards, tookInMillis, shardFailures, clusters, null);
    }

    public SearchResponse(SearchResponseSections searchResponseSections, String scrollId, int totalShards, int successfulShards, int skippedShards, long tookInMillis, ShardSearchFailure[] shardFailures, Clusters clusters, BytesReference pointInTimeId) {
        this(searchResponseSections.hits, searchResponseSections.aggregations, searchResponseSections.suggest, searchResponseSections.timedOut, searchResponseSections.terminatedEarly, searchResponseSections.profileResults, searchResponseSections.numReducePhases, scrollId, totalShards, successfulShards, skippedShards, tookInMillis, shardFailures, clusters, pointInTimeId);
    }

    public SearchResponse(SearchHits hits, InternalAggregations aggregations, Suggest suggest, boolean timedOut, Boolean terminatedEarly, SearchProfileResults profileResults, int numReducePhases, String scrollId, int totalShards, int successfulShards, int skippedShards, long tookInMillis, ShardSearchFailure[] shardFailures, Clusters clusters, BytesReference pointInTimeId) {
        this.hits = hits;
        hits.incRef();
        this.aggregations = aggregations;
        this.suggest = suggest;
        this.profileResults = profileResults;
        this.timedOut = timedOut;
        this.terminatedEarly = terminatedEarly;
        this.numReducePhases = numReducePhases;
        this.scrollId = scrollId;
        this.pointInTimeId = pointInTimeId;
        this.clusters = clusters;
        this.totalShards = totalShards;
        this.successfulShards = successfulShards;
        this.skippedShards = skippedShards;
        this.tookInMillis = tookInMillis;
        this.shardFailures = shardFailures;
        assert (skippedShards <= totalShards) : "skipped: " + skippedShards + " total: " + totalShards;
        assert (scrollId == null || pointInTimeId == null) : "SearchResponse can't have both scrollId [" + scrollId + "] and searchContextId [" + String.valueOf(pointInTimeId) + "]";
    }

    @Override
    public void incRef() {
        this.refCounted.incRef();
    }

    @Override
    public boolean tryIncRef() {
        return this.refCounted.tryIncRef();
    }

    @Override
    public boolean decRef() {
        if (this.refCounted.decRef()) {
            this.hits.decRef();
            return true;
        }
        return false;
    }

    @Override
    public boolean hasReferences() {
        return this.refCounted.hasReferences();
    }

    public RestStatus status() {
        return RestStatus.status(this.successfulShards, this.totalShards, this.shardFailures);
    }

    public SearchHits getHits() {
        assert (this.hasReferences());
        return this.hits;
    }

    @Nullable
    public InternalAggregations getAggregations() {
        return this.aggregations;
    }

    public boolean hasAggregations() {
        return this.getAggregations() != null && this.getAggregations() != InternalAggregations.EMPTY;
    }

    public Suggest getSuggest() {
        return this.suggest;
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }

    public Boolean isTerminatedEarly() {
        return this.terminatedEarly;
    }

    public int getNumReducePhases() {
        return this.numReducePhases;
    }

    public TimeValue getTook() {
        return new TimeValue(this.tookInMillis);
    }

    public long getTookInMillis() {
        return this.tookInMillis;
    }

    public int getTotalShards() {
        return this.totalShards;
    }

    public int getSuccessfulShards() {
        return this.successfulShards;
    }

    public int getSkippedShards() {
        return this.skippedShards;
    }

    public int getFailedShards() {
        return this.shardFailures.length;
    }

    public ShardSearchFailure[] getShardFailures() {
        return this.shardFailures;
    }

    public String getScrollId() {
        return this.scrollId;
    }

    public BytesReference pointInTimeId() {
        return this.pointInTimeId;
    }

    @Nullable
    public Map<String, SearchProfileShardResult> getProfileResults() {
        if (this.profileResults == null) {
            return Collections.emptyMap();
        }
        return this.profileResults.getShardResults();
    }

    public Clusters getClusters() {
        return this.clusters;
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        assert (this.hasReferences());
        return this.getToXContentIterator(true, params);
    }

    public Iterator<? extends ToXContent> innerToXContentChunked(ToXContent.Params params) {
        return this.getToXContentIterator(false, params);
    }

    private Iterator<ToXContent> getToXContentIterator(boolean wrapInObject, ToXContent.Params params) {
        return Iterators.concat(wrapInObject ? ChunkedToXContentHelper.startObject() : Collections.emptyIterator(), ChunkedToXContentHelper.chunk(this::headerToXContent), Iterators.single(this.clusters), this.hits.toXContentChunked(params), this.aggregations == null ? Collections.emptyIterator() : ChunkedToXContentHelper.chunk(this.aggregations), this.suggest == null ? Collections.emptyIterator() : ChunkedToXContentHelper.chunk(this.suggest), this.profileResults == null ? Collections.emptyIterator() : ChunkedToXContentHelper.chunk(this.profileResults), wrapInObject ? ChunkedToXContentHelper.endObject() : Collections.emptyIterator());
    }

    public XContentBuilder headerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.scrollId != null) {
            builder.field(SCROLL_ID.getPreferredName(), this.scrollId);
        }
        if (this.pointInTimeId != null) {
            builder.field(POINT_IN_TIME_ID.getPreferredName(), Base64.getUrlEncoder().encodeToString(BytesReference.toBytes(this.pointInTimeId)));
        }
        builder.field(TOOK.getPreferredName(), this.tookInMillis);
        builder.field(TIMED_OUT.getPreferredName(), this.isTimedOut());
        if (this.isTerminatedEarly() != null) {
            builder.field(TERMINATED_EARLY.getPreferredName(), this.isTerminatedEarly());
        }
        if (this.getNumReducePhases() != 1) {
            builder.field(NUM_REDUCE_PHASES.getPreferredName(), this.getNumReducePhases());
        }
        RestActions.buildBroadcastShardsHeader(builder, params, this.getTotalShards(), this.getSuccessfulShards(), this.getSkippedShards(), this.getFailedShards(), this.getShardFailures());
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        assert (this.hasReferences());
        this.hits.writeTo(out);
        out.writeOptionalWriteable(this.aggregations);
        out.writeOptionalWriteable(this.suggest);
        out.writeBoolean(this.timedOut);
        out.writeOptionalBoolean(this.terminatedEarly);
        out.writeOptionalWriteable(this.profileResults);
        out.writeVInt(this.numReducePhases);
        out.writeVInt(this.totalShards);
        out.writeVInt(this.successfulShards);
        out.writeVInt(this.shardFailures.length);
        for (ShardSearchFailure shardSearchFailure : this.shardFailures) {
            shardSearchFailure.writeTo(out);
        }
        this.clusters.writeTo(out);
        out.writeOptionalString(this.scrollId);
        out.writeVLong(this.tookInMillis);
        out.writeVInt(this.skippedShards);
        out.writeOptionalBytesReference(this.pointInTimeId);
    }

    public String toString() {
        return !this.hasReferences() ? "SearchResponse[released]" : Strings.toString(this);
    }

    public static SearchResponse empty(Supplier<Long> tookInMillisSupplier, Clusters clusters) {
        return new SearchResponse(SearchHits.empty(Lucene.TOTAL_HITS_EQUAL_TO_ZERO, Float.NaN), InternalAggregations.EMPTY, null, false, null, null, 0, null, 0, 0, 0, tookInMillisSupplier.get(), ShardSearchFailure.EMPTY_ARRAY, clusters, null);
    }

    public static final class Clusters
    implements ToXContentFragment,
    Writeable {
        public static final Clusters EMPTY = new Clusters(0, 0, 0);
        public static final ParseField _CLUSTERS_FIELD = new ParseField("_clusters", new String[0]);
        public static final ParseField TOTAL_FIELD = new ParseField("total", new String[0]);
        public static final ParseField SUCCESSFUL_FIELD = new ParseField("successful", new String[0]);
        public static final ParseField SKIPPED_FIELD = new ParseField("skipped", new String[0]);
        public static final ParseField RUNNING_FIELD = new ParseField("running", new String[0]);
        public static final ParseField PARTIAL_FIELD = new ParseField("partial", new String[0]);
        public static final ParseField FAILED_FIELD = new ParseField("failed", new String[0]);
        public static final ParseField DETAILS_FIELD = new ParseField("details", new String[0]);
        private final int total;
        private final int successful;
        private final int skipped;
        private final Map<String, Cluster> clusterInfo;
        private final transient Boolean ccsMinimizeRoundtrips;

        public Clusters(@Nullable OriginalIndices localIndices, Map<String, OriginalIndices> remoteClusterIndices, boolean ccsMinimizeRoundtrips, Predicate<String> skipUnavailablePredicate) {
            assert (remoteClusterIndices.size() > 0) : "At least one remote cluster must be passed into this Cluster constructor";
            this.total = remoteClusterIndices.size() + (localIndices == null ? 0 : 1);
            assert (this.total >= 1) : "No local indices or remote clusters passed in";
            this.successful = 0;
            this.skipped = 0;
            this.ccsMinimizeRoundtrips = ccsMinimizeRoundtrips;
            ConcurrentMap<String, Cluster> m = ConcurrentCollections.newConcurrentMap();
            if (localIndices != null) {
                String localKey = "";
                Cluster c = new Cluster(localKey, String.join((CharSequence)",", localIndices.indices()), false);
                m.put(localKey, c);
            }
            for (Map.Entry<String, OriginalIndices> remote : remoteClusterIndices.entrySet()) {
                String clusterAlias = remote.getKey();
                boolean skipUnavailable = skipUnavailablePredicate.test(clusterAlias);
                Cluster c = new Cluster(clusterAlias, String.join((CharSequence)",", remote.getValue().indices()), skipUnavailable);
                m.put(clusterAlias, c);
            }
            this.clusterInfo = m;
        }

        public Clusters(int total, int successful, int skipped) {
            assert (total >= 0 && successful >= 0 && skipped >= 0 && successful <= total) : "total: " + total + " successful: " + successful + " skipped: " + skipped;
            assert (skipped == total - successful) : "total: " + total + " successful: " + successful + " skipped: " + skipped;
            this.total = total;
            this.successful = successful;
            this.skipped = skipped;
            this.ccsMinimizeRoundtrips = false;
            this.clusterInfo = Collections.emptyMap();
        }

        public Clusters(StreamInput in) throws IOException {
            this.total = in.readVInt();
            int successfulTemp = in.readVInt();
            int skippedTemp = in.readVInt();
            if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_10_X)) {
                List<Cluster> clusterList = in.readCollectionAsList(Cluster::new);
                if (clusterList.isEmpty()) {
                    this.clusterInfo = Collections.emptyMap();
                    this.successful = successfulTemp;
                    this.skipped = skippedTemp;
                } else {
                    ConcurrentMap<String, Cluster> m = ConcurrentCollections.newConcurrentMap();
                    clusterList.forEach(c -> m.put(c.getClusterAlias(), (Cluster)c));
                    this.clusterInfo = m;
                    this.successful = this.getClusterStateCount(Cluster.Status.SUCCESSFUL);
                    this.skipped = this.getClusterStateCount(Cluster.Status.SKIPPED);
                }
            } else {
                this.successful = successfulTemp;
                this.skipped = skippedTemp;
                this.clusterInfo = Collections.emptyMap();
            }
            int running = this.getClusterStateCount(Cluster.Status.RUNNING);
            int partial = this.getClusterStateCount(Cluster.Status.PARTIAL);
            int failed = this.getClusterStateCount(Cluster.Status.FAILED);
            this.ccsMinimizeRoundtrips = false;
            assert (this.total >= 0) : "total is negative: " + this.total;
            assert (this.total == this.successful + this.skipped + running + partial + failed) : "successful + skipped + running + partial + failed is not equal to total. total: " + this.total + " successful: " + this.successful + " skipped: " + this.skipped + " running: " + running + " partial: " + partial + " failed: " + failed;
        }

        public Clusters(Map<String, Cluster> clusterInfoMap) {
            assert (clusterInfoMap.size() > 0) : "this constructor should not be called with an empty Cluster info map";
            this.total = clusterInfoMap.size();
            this.clusterInfo = clusterInfoMap;
            this.successful = this.getClusterStateCount(Cluster.Status.SUCCESSFUL);
            this.skipped = this.getClusterStateCount(Cluster.Status.SKIPPED);
            this.ccsMinimizeRoundtrips = true;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.total);
            out.writeVInt(this.successful);
            out.writeVInt(this.skipped);
            if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_10_X)) {
                if (this.clusterInfo != null) {
                    List<Cluster> clusterList = this.clusterInfo.values().stream().toList();
                    out.writeCollection(clusterList);
                } else {
                    out.writeCollection(Collections.emptyList());
                }
            }
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.total > 0) {
                builder.startObject(_CLUSTERS_FIELD.getPreferredName());
                builder.field(TOTAL_FIELD.getPreferredName(), this.total);
                builder.field(SUCCESSFUL_FIELD.getPreferredName(), this.getClusterStateCount(Cluster.Status.SUCCESSFUL));
                builder.field(SKIPPED_FIELD.getPreferredName(), this.getClusterStateCount(Cluster.Status.SKIPPED));
                builder.field(RUNNING_FIELD.getPreferredName(), this.getClusterStateCount(Cluster.Status.RUNNING));
                builder.field(PARTIAL_FIELD.getPreferredName(), this.getClusterStateCount(Cluster.Status.PARTIAL));
                builder.field(FAILED_FIELD.getPreferredName(), this.getClusterStateCount(Cluster.Status.FAILED));
                if (this.clusterInfo.size() > 0) {
                    builder.startObject("details");
                    for (Cluster cluster : this.clusterInfo.values()) {
                        cluster.toXContent(builder, params);
                    }
                    builder.endObject();
                }
                builder.endObject();
            }
            return builder;
        }

        public int getTotal() {
            return this.total;
        }

        public int getClusterStateCount(Cluster.Status status) {
            if (this.clusterInfo.isEmpty()) {
                return switch (status.ordinal()) {
                    case 1 -> this.successful;
                    case 3 -> this.skipped;
                    default -> 0;
                };
            }
            return this.determineCountFromClusterInfo(cluster -> cluster.getStatus() == status);
        }

        private int determineCountFromClusterInfo(Predicate<Cluster> predicate) {
            return (int)this.clusterInfo.values().stream().filter(predicate).count();
        }

        public Boolean isCcsMinimizeRoundtrips() {
            return this.ccsMinimizeRoundtrips;
        }

        public Cluster getCluster(String clusterAlias) {
            return this.clusterInfo.get(clusterAlias);
        }

        public Set<String> getClusterAliases() {
            return this.clusterInfo.keySet();
        }

        public Cluster swapCluster(String clusterAlias, BiFunction<String, Cluster, Cluster> remappingFunction) {
            return this.clusterInfo.compute(clusterAlias, remappingFunction);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Clusters clusters = (Clusters)o;
            return this.total == clusters.total && this.getClusterStateCount(Cluster.Status.SUCCESSFUL) == clusters.getClusterStateCount(Cluster.Status.SUCCESSFUL) && this.getClusterStateCount(Cluster.Status.SKIPPED) == clusters.getClusterStateCount(Cluster.Status.SKIPPED) && this.getClusterStateCount(Cluster.Status.RUNNING) == clusters.getClusterStateCount(Cluster.Status.RUNNING) && this.getClusterStateCount(Cluster.Status.PARTIAL) == clusters.getClusterStateCount(Cluster.Status.PARTIAL) && this.getClusterStateCount(Cluster.Status.FAILED) == clusters.getClusterStateCount(Cluster.Status.FAILED);
        }

        public int hashCode() {
            return Objects.hash(this.total, this.getClusterStateCount(Cluster.Status.SUCCESSFUL), this.getClusterStateCount(Cluster.Status.SKIPPED), this.getClusterStateCount(Cluster.Status.RUNNING), this.getClusterStateCount(Cluster.Status.PARTIAL), this.getClusterStateCount(Cluster.Status.FAILED));
        }

        public String toString() {
            return "Clusters{total=" + this.total + ", successful=" + this.getClusterStateCount(Cluster.Status.SUCCESSFUL) + ", skipped=" + this.getClusterStateCount(Cluster.Status.SKIPPED) + ", running=" + this.getClusterStateCount(Cluster.Status.RUNNING) + ", partial=" + this.getClusterStateCount(Cluster.Status.PARTIAL) + ", failed=" + this.getClusterStateCount(Cluster.Status.FAILED) + "}";
        }

        public boolean hasPartialResults() {
            for (Cluster cluster : this.clusterInfo.values()) {
                switch (cluster.getStatus().ordinal()) {
                    case 0: 
                    case 2: 
                    case 3: 
                    case 4: {
                        return true;
                    }
                }
                if (!cluster.isTimedOut()) continue;
                return true;
            }
            return false;
        }

        public boolean hasClusterObjects() {
            return !this.clusterInfo.isEmpty();
        }

        public boolean hasRemoteClusters() {
            return this.total > 1 || this.clusterInfo.keySet().stream().anyMatch(alias -> !alias.equals(""));
        }
    }

    public static class Cluster
    implements ToXContentFragment,
    Writeable {
        public static final ParseField INDICES_FIELD = new ParseField("indices", new String[0]);
        public static final ParseField STATUS_FIELD = new ParseField("status", new String[0]);
        public static final boolean SKIP_UNAVAILABLE_DEFAULT = false;
        private final String clusterAlias;
        private final String indexExpression;
        private final boolean skipUnavailable;
        private final Status status;
        private final Integer totalShards;
        private final Integer successfulShards;
        private final Integer skippedShards;
        private final Integer failedShards;
        private final List<ShardSearchFailure> failures;
        private final TimeValue took;
        private final boolean timedOut;

        public Cluster(String clusterAlias, String indexExpression, boolean skipUnavailable) {
            this(clusterAlias, indexExpression, skipUnavailable, Status.RUNNING, null, null, null, null, null, null, false);
        }

        public Cluster(String clusterAlias, String indexExpression, boolean skipUnavailable, Status status, Integer totalShards, Integer successfulShards, Integer skippedShards, Integer failedShards, List<ShardSearchFailure> failures, TimeValue took, boolean timedOut) {
            assert (clusterAlias != null) : "clusterAlias cannot be null";
            assert (indexExpression != null) : "indexExpression of Cluster cannot be null";
            assert (status != null) : "status of Cluster cannot be null";
            this.clusterAlias = clusterAlias;
            this.indexExpression = indexExpression;
            this.skipUnavailable = skipUnavailable;
            this.status = status;
            this.totalShards = totalShards;
            this.successfulShards = successfulShards;
            this.skippedShards = skippedShards;
            this.failedShards = failedShards;
            this.failures = failures == null ? Collections.emptyList() : Collections.unmodifiableList(failures);
            this.took = took;
            this.timedOut = timedOut;
        }

        public Cluster(StreamInput in) throws IOException {
            this.clusterAlias = in.readString();
            this.indexExpression = in.readString();
            this.status = Status.valueOf(in.readString().toUpperCase(Locale.ROOT));
            this.totalShards = in.readOptionalInt();
            this.successfulShards = in.readOptionalInt();
            this.skippedShards = in.readOptionalInt();
            this.failedShards = in.readOptionalInt();
            Long took = in.readOptionalLong();
            this.took = took == null ? null : new TimeValue(took);
            this.timedOut = in.readBoolean();
            this.failures = Collections.unmodifiableList(in.readCollectionAsList(ShardSearchFailure::readShardSearchFailure));
            this.skipUnavailable = in.getTransportVersion().onOrAfter(TransportVersions.V_8_11_X) ? in.readBoolean() : false;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.clusterAlias);
            out.writeString(this.indexExpression);
            out.writeString(this.status.toString());
            out.writeOptionalInt(this.totalShards);
            out.writeOptionalInt(this.successfulShards);
            out.writeOptionalInt(this.skippedShards);
            out.writeOptionalInt(this.failedShards);
            out.writeOptionalLong(this.took == null ? null : Long.valueOf(this.took.millis()));
            out.writeBoolean(this.timedOut);
            out.writeCollection(this.failures);
            if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_11_X)) {
                out.writeBoolean(this.skipUnavailable);
            }
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            String name = this.clusterAlias;
            if (this.clusterAlias.isEmpty()) {
                name = SearchResponse.LOCAL_CLUSTER_NAME_REPRESENTATION;
            }
            builder.startObject(name);
            builder.field(STATUS_FIELD.getPreferredName(), this.getStatus().toString());
            builder.field(INDICES_FIELD.getPreferredName(), this.indexExpression);
            if (this.took != null) {
                builder.field(TOOK.getPreferredName(), this.took.millis());
            }
            builder.field(TIMED_OUT.getPreferredName(), this.timedOut);
            if (this.totalShards != null) {
                builder.startObject(RestActions._SHARDS_FIELD.getPreferredName());
                builder.field(RestActions.TOTAL_FIELD.getPreferredName(), this.totalShards);
                if (this.successfulShards != null) {
                    builder.field(RestActions.SUCCESSFUL_FIELD.getPreferredName(), this.successfulShards);
                }
                if (this.skippedShards != null) {
                    builder.field(RestActions.SKIPPED_FIELD.getPreferredName(), this.skippedShards);
                }
                if (this.failedShards != null) {
                    builder.field(RestActions.FAILED_FIELD.getPreferredName(), this.failedShards);
                }
                builder.endObject();
            }
            if (this.failures != null && this.failures.size() > 0) {
                builder.startArray(RestActions.FAILURES_FIELD.getPreferredName());
                for (ShardSearchFailure failure : this.failures) {
                    failure.toXContent(builder, params);
                }
                builder.endArray();
            }
            builder.endObject();
            return builder;
        }

        public String getClusterAlias() {
            return this.clusterAlias;
        }

        public String getIndexExpression() {
            return this.indexExpression;
        }

        public boolean isSkipUnavailable() {
            return this.skipUnavailable;
        }

        public Status getStatus() {
            return this.status;
        }

        public boolean isTimedOut() {
            return this.timedOut;
        }

        public List<ShardSearchFailure> getFailures() {
            return this.failures;
        }

        public TimeValue getTook() {
            return this.took;
        }

        public Integer getTotalShards() {
            return this.totalShards;
        }

        public Integer getSuccessfulShards() {
            return this.successfulShards;
        }

        public Integer getSkippedShards() {
            return this.skippedShards;
        }

        public Integer getFailedShards() {
            return this.failedShards;
        }

        public String toString() {
            return "Cluster{alias='" + this.clusterAlias + "', status=" + String.valueOf((Object)this.status) + ", totalShards=" + this.totalShards + ", successfulShards=" + this.successfulShards + ", skippedShards=" + this.skippedShards + ", failedShards=" + this.failedShards + ", failures(sz)=" + this.failures.size() + ", took=" + String.valueOf(this.took) + ", timedOut=" + this.timedOut + ", indexExpression='" + this.indexExpression + "', skipUnavailable=" + this.skipUnavailable + "}";
        }

        public static enum Status {
            RUNNING,
            SUCCESSFUL,
            PARTIAL,
            SKIPPED,
            FAILED;


            public String toString() {
                return this.name().toLowerCase(Locale.ROOT);
            }
        }

        public static class Builder {
            private Status status;
            private Integer totalShards;
            private Integer successfulShards;
            private Integer skippedShards;
            private Integer failedShards;
            private List<ShardSearchFailure> failures;
            private TimeValue took;
            private Boolean timedOut;
            private final Cluster original;

            public Builder(Cluster copyFrom) {
                this.original = copyFrom;
            }

            public Cluster build() {
                return new Cluster(this.original.getClusterAlias(), this.original.getIndexExpression(), this.original.isSkipUnavailable(), this.status != null ? this.status : this.original.getStatus(), this.totalShards != null ? this.totalShards : this.original.getTotalShards(), this.successfulShards != null ? this.successfulShards : this.original.getSuccessfulShards(), this.skippedShards != null ? this.skippedShards : this.original.getSkippedShards(), this.failedShards != null ? this.failedShards : this.original.getFailedShards(), this.failures != null ? this.failures : this.original.getFailures(), this.took != null ? this.took : this.original.getTook(), this.timedOut != null ? this.timedOut.booleanValue() : this.original.isTimedOut());
            }

            public Builder setStatus(Status status) {
                this.status = status;
                return this;
            }

            public Builder setTotalShards(int totalShards) {
                this.totalShards = totalShards;
                return this;
            }

            public Builder setSuccessfulShards(int successfulShards) {
                this.successfulShards = successfulShards;
                return this;
            }

            public Builder setSkippedShards(int skippedShards) {
                this.skippedShards = skippedShards;
                return this;
            }

            public Builder setFailedShards(int failedShards) {
                this.failedShards = failedShards;
                return this;
            }

            public Builder setFailures(List<ShardSearchFailure> failures) {
                this.failures = failures;
                return this;
            }

            public Builder setTook(TimeValue took) {
                this.took = took;
                return this;
            }

            public Builder setTimedOut(boolean timedOut) {
                this.timedOut = timedOut;
                return this;
            }
        }
    }
}

