/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.index;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.bulk.IndexDocFailureStoreStatus;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class IndexResponse
extends DocWriteResponse {
    @Nullable
    protected final List<String> executedPipelines;
    private IndexDocFailureStoreStatus failureStoreStatus;

    public IndexResponse(ShardId shardId, StreamInput in) throws IOException {
        super(shardId, in);
        this.executedPipelines = in.getTransportVersion().onOrAfter(TransportVersions.V_8_12_0) ? in.readOptionalCollectionAsList(StreamInput::readString) : null;
        this.failureStoreStatus = in.getTransportVersion().onOrAfter(TransportVersions.V_8_16_0) ? IndexDocFailureStoreStatus.read(in) : IndexDocFailureStoreStatus.NOT_APPLICABLE_OR_UNKNOWN;
    }

    public IndexResponse(StreamInput in) throws IOException {
        super(in);
        this.executedPipelines = in.getTransportVersion().onOrAfter(TransportVersions.V_8_12_0) ? in.readOptionalCollectionAsList(StreamInput::readString) : null;
        this.failureStoreStatus = in.getTransportVersion().onOrAfter(TransportVersions.V_8_16_0) ? IndexDocFailureStoreStatus.read(in) : IndexDocFailureStoreStatus.NOT_APPLICABLE_OR_UNKNOWN;
    }

    public IndexResponse(ShardId shardId, String id, long seqNo, long primaryTerm, long version, boolean created) {
        this(shardId, id, seqNo, primaryTerm, version, created, null, IndexDocFailureStoreStatus.NOT_APPLICABLE_OR_UNKNOWN);
    }

    public IndexResponse(ShardId shardId, String id, long seqNo, long primaryTerm, long version, boolean created, @Nullable List<String> executedPipelines) {
        this(shardId, id, seqNo, primaryTerm, version, created ? DocWriteResponse.Result.CREATED : DocWriteResponse.Result.UPDATED, executedPipelines, IndexDocFailureStoreStatus.NOT_APPLICABLE_OR_UNKNOWN);
    }

    public IndexResponse(ShardId shardId, String id, long seqNo, long primaryTerm, long version, boolean created, @Nullable List<String> executedPipelines, IndexDocFailureStoreStatus failureStoreStatus) {
        this(shardId, id, seqNo, primaryTerm, version, created ? DocWriteResponse.Result.CREATED : DocWriteResponse.Result.UPDATED, executedPipelines, failureStoreStatus);
    }

    private IndexResponse(ShardId shardId, String id, long seqNo, long primaryTerm, long version, DocWriteResponse.Result result, @Nullable List<String> executedPipelines, IndexDocFailureStoreStatus failureStoreStatus) {
        super(shardId, id, seqNo, primaryTerm, version, IndexResponse.assertCreatedOrUpdated(result));
        this.executedPipelines = executedPipelines;
        this.failureStoreStatus = failureStoreStatus;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_12_0)) {
            out.writeOptionalCollection(this.executedPipelines, StreamOutput::writeString);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_16_0)) {
            this.failureStoreStatus.writeTo(out);
        }
    }

    @Override
    public void writeThin(StreamOutput out) throws IOException {
        super.writeThin(out);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_12_0)) {
            out.writeOptionalCollection(this.executedPipelines, StreamOutput::writeString);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_16_0)) {
            this.failureStoreStatus.writeTo(out);
        }
    }

    @Override
    public XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder updatedBuilder = super.innerToXContent(builder, params);
        if (this.executedPipelines != null) {
            updatedBuilder = updatedBuilder.field("executed_pipelines", this.executedPipelines.toArray());
        }
        this.failureStoreStatus.toXContent(builder, params);
        return updatedBuilder;
    }

    private static DocWriteResponse.Result assertCreatedOrUpdated(DocWriteResponse.Result result) {
        assert (result == DocWriteResponse.Result.CREATED || result == DocWriteResponse.Result.UPDATED);
        return result;
    }

    @Override
    public RestStatus status() {
        return this.result == DocWriteResponse.Result.CREATED ? RestStatus.CREATED : super.status();
    }

    public void setFailureStoreStatus(IndexDocFailureStoreStatus failureStoreStatus) {
        this.failureStoreStatus = failureStoreStatus;
    }

    @Override
    public IndexDocFailureStoreStatus getFailureStoreStatus() {
        return this.failureStoreStatus;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("IndexResponse[");
        builder.append("index=").append(this.getIndex());
        builder.append(",id=").append(this.getId());
        builder.append(",version=").append(this.getVersion());
        builder.append(",result=").append(this.getResult().getLowercase());
        builder.append(",seqNo=").append(this.getSeqNo());
        builder.append(",primaryTerm=").append(this.getPrimaryTerm());
        builder.append(",shards=").append(Strings.toString(this.getShardInfo()));
        builder.append(",failure_store=").append(this.failureStoreStatus.getLabel());
        return builder.append("]").toString();
    }

    public static class Builder
    extends DocWriteResponse.Builder {
        @Override
        public IndexResponse build() {
            IndexResponse indexResponse = new IndexResponse(this.shardId, this.id, this.seqNo, this.primaryTerm, (long)this.version, this.result, null, IndexDocFailureStoreStatus.NOT_APPLICABLE_OR_UNKNOWN);
            indexResponse.setForcedRefresh(this.forcedRefresh);
            if (this.shardInfo != null) {
                indexResponse.setShardInfo(this.shardInfo);
            }
            return indexResponse;
        }
    }
}

