/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.datastreams;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.metadata.DataStreamFailureStore;
import org.elasticsearch.cluster.metadata.DataStreamOptions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;

public class PutDataStreamOptionsAction {
    public static final ActionType<AcknowledgedResponse> INSTANCE = new ActionType("indices:admin/data_stream/options/put");

    private PutDataStreamOptionsAction() {
    }

    public static final class Request
    extends AcknowledgedRequest<Request>
    implements IndicesRequest.Replaceable {
        public static final ConstructingObjectParser<Request, Factory> PARSER = new ConstructingObjectParser<Request, Factory>("put_data_stream_options_request", false, (args, factory) -> factory.create((DataStreamFailureStore)args[0]));
        private String[] names;
        private IndicesOptions indicesOptions = IndicesOptions.builder().concreteTargetOptions(IndicesOptions.ConcreteTargetOptions.ERROR_WHEN_UNAVAILABLE_TARGETS).wildcardOptions(IndicesOptions.WildcardOptions.builder().matchOpen(true).matchClosed(true).allowEmptyExpressions(true).resolveAliases(false)).gatekeeperOptions(IndicesOptions.GatekeeperOptions.builder().allowAliasToMultipleIndices(false).allowClosedIndices(true).allowSelectors(false)).build();
        private final DataStreamOptions options;

        public static Request parseRequest(XContentParser parser, Factory factory) {
            return PARSER.apply(parser, factory);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.names = in.readStringArray();
            this.indicesOptions = IndicesOptions.readIndicesOptions(in);
            this.options = DataStreamOptions.read(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeStringArray(this.names);
            this.indicesOptions.writeIndicesOptions(out);
            out.writeWriteable(this.options);
        }

        public Request(TimeValue masterNodeTimeout, TimeValue ackTimeout, String[] names, DataStreamOptions options) {
            super(masterNodeTimeout, ackTimeout);
            this.names = names;
            this.options = options;
        }

        public Request(TimeValue masterNodeTimeout, TimeValue ackTimeout, String[] names, @Nullable DataStreamFailureStore failureStore) {
            super(masterNodeTimeout, ackTimeout);
            this.names = names;
            this.options = new DataStreamOptions(failureStore);
        }

        @Override
        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.options.failureStore() == null) {
                validationException = ValidateActions.addValidationError("At least one option needs to be provided", validationException);
            }
            return validationException;
        }

        public String[] getNames() {
            return this.names;
        }

        public DataStreamOptions getOptions() {
            return this.options;
        }

        @Override
        public String[] indices() {
            return this.names;
        }

        @Override
        public IndicesOptions indicesOptions() {
            return this.indicesOptions;
        }

        public Request indicesOptions(IndicesOptions indicesOptions) {
            this.indicesOptions = indicesOptions;
            return this;
        }

        @Override
        public boolean includeDataStreams() {
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Arrays.equals(this.names, request.names) && Objects.equals(this.indicesOptions, request.indicesOptions) && this.options.equals(request.options);
        }

        public int hashCode() {
            int result = Objects.hash(this.indicesOptions, this.options);
            result = 31 * result + Arrays.hashCode(this.names);
            return result;
        }

        @Override
        public IndicesRequest indices(String ... names) {
            this.names = names;
            return this;
        }

        static {
            PARSER.declareObjectOrNull(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> DataStreamFailureStore.PARSER.parse(p, null), null, new ParseField("failure_store", new String[0]));
        }

        public static interface Factory {
            public Request create(@Nullable DataStreamFailureStore var1);
        }
    }
}

