/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action;

import org.elasticsearch.xcontent.ToXContent;

public enum ClusterStatsLevel {
    CLUSTER("cluster"),
    INDICES("indices"),
    SHARDS("shards");

    private final String level;

    private ClusterStatsLevel(String level) {
        this.level = level;
    }

    public String getLevel() {
        return this.level;
    }

    public static ClusterStatsLevel of(String level) {
        for (ClusterStatsLevel value : ClusterStatsLevel.values()) {
            if (!value.getLevel().equalsIgnoreCase(level)) continue;
            return value;
        }
        throw new IllegalArgumentException("level parameter must be one of [cluster] or [indices] or [shards] but was [" + level + "]");
    }

    public static ClusterStatsLevel of(ToXContent.Params params, ClusterStatsLevel defaultLevel) {
        return ClusterStatsLevel.of(params.param("level", defaultLevel.getLevel()));
    }
}

