/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logstash.filters.elasticintegration;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.ingest.PipelineConfiguration;
import org.elasticsearch.xcontent.XContentType;

public class PipelineConfigurationFactory {
    public static final PipelineConfigurationFactory INSTANCE = new PipelineConfigurationFactory();

    public static PipelineConfigurationFactory getInstance() {
        return INSTANCE;
    }

    private PipelineConfigurationFactory() {
    }

    public List<PipelineConfiguration> parseNamedObjects(String json) throws Exception {
        return ((Spec)Spec.MAPPER.readValue(json, Spec.class)).get();
    }

    public PipelineConfiguration parseNamedObject(String json) throws Exception {
        List<PipelineConfiguration> configs = this.parseNamedObjects(json);
        if (configs.isEmpty()) {
            throw new IllegalStateException("Expected a single pipeline definition. Got none");
        }
        if (configs.size() > 1) {
            throw new IllegalStateException("Expected a single pipeline definition. Got " + configs.size());
        }
        return configs.get(0);
    }

    public PipelineConfiguration parseConfigOnly(String pipelineId, String jsonEncodedConfig) {
        return new PipelineConfiguration(pipelineId, new BytesArray(jsonEncodedConfig), XContentType.JSON);
    }

    private static class Spec {
        private static final ObjectMapper MAPPER = new ObjectMapper();
        private final Map<String, String> idToConfigMap = new LinkedHashMap<String, String>();

        private Spec() {
        }

        @JsonAnySetter
        public void setConfig(String pipelineId, JsonNode jsonNode) throws JsonProcessingException {
            this.idToConfigMap.put(pipelineId, MAPPER.writeValueAsString((Object)jsonNode));
        }

        public List<PipelineConfiguration> get() {
            return this.idToConfigMap.entrySet().stream().map(e -> Spec.init((String)e.getKey(), (String)e.getValue())).toList();
        }

        private static PipelineConfiguration init(String id, String json) {
            return new PipelineConfiguration(id, new BytesArray(json), XContentType.JSON);
        }
    }
}

