/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.termvectors;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Filter
implements JsonpSerializable {
    @Nullable
    private final Integer maxDocFreq;
    @Nullable
    private final Integer maxNumTerms;
    @Nullable
    private final Integer maxTermFreq;
    @Nullable
    private final Integer maxWordLength;
    @Nullable
    private final Integer minDocFreq;
    @Nullable
    private final Integer minTermFreq;
    @Nullable
    private final Integer minWordLength;
    public static final JsonpDeserializer<Filter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Filter::setupFilterDeserializer);

    private Filter(Builder builder) {
        this.maxDocFreq = builder.maxDocFreq;
        this.maxNumTerms = builder.maxNumTerms;
        this.maxTermFreq = builder.maxTermFreq;
        this.maxWordLength = builder.maxWordLength;
        this.minDocFreq = builder.minDocFreq;
        this.minTermFreq = builder.minTermFreq;
        this.minWordLength = builder.minWordLength;
    }

    public static Filter of(Function<Builder, ObjectBuilder<Filter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Integer maxDocFreq() {
        return this.maxDocFreq;
    }

    @Nullable
    public final Integer maxNumTerms() {
        return this.maxNumTerms;
    }

    @Nullable
    public final Integer maxTermFreq() {
        return this.maxTermFreq;
    }

    @Nullable
    public final Integer maxWordLength() {
        return this.maxWordLength;
    }

    @Nullable
    public final Integer minDocFreq() {
        return this.minDocFreq;
    }

    @Nullable
    public final Integer minTermFreq() {
        return this.minTermFreq;
    }

    @Nullable
    public final Integer minWordLength() {
        return this.minWordLength;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.maxDocFreq != null) {
            generator.writeKey("max_doc_freq");
            generator.write(this.maxDocFreq);
        }
        if (this.maxNumTerms != null) {
            generator.writeKey("max_num_terms");
            generator.write(this.maxNumTerms);
        }
        if (this.maxTermFreq != null) {
            generator.writeKey("max_term_freq");
            generator.write(this.maxTermFreq);
        }
        if (this.maxWordLength != null) {
            generator.writeKey("max_word_length");
            generator.write(this.maxWordLength);
        }
        if (this.minDocFreq != null) {
            generator.writeKey("min_doc_freq");
            generator.write(this.minDocFreq);
        }
        if (this.minTermFreq != null) {
            generator.writeKey("min_term_freq");
            generator.write(this.minTermFreq);
        }
        if (this.minWordLength != null) {
            generator.writeKey("min_word_length");
            generator.write(this.minWordLength);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupFilterDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::maxDocFreq, JsonpDeserializer.integerDeserializer(), "max_doc_freq");
        op.add(Builder::maxNumTerms, JsonpDeserializer.integerDeserializer(), "max_num_terms");
        op.add(Builder::maxTermFreq, JsonpDeserializer.integerDeserializer(), "max_term_freq");
        op.add(Builder::maxWordLength, JsonpDeserializer.integerDeserializer(), "max_word_length");
        op.add(Builder::minDocFreq, JsonpDeserializer.integerDeserializer(), "min_doc_freq");
        op.add(Builder::minTermFreq, JsonpDeserializer.integerDeserializer(), "min_term_freq");
        op.add(Builder::minWordLength, JsonpDeserializer.integerDeserializer(), "min_word_length");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Filter> {
        @Nullable
        private Integer maxDocFreq;
        @Nullable
        private Integer maxNumTerms;
        @Nullable
        private Integer maxTermFreq;
        @Nullable
        private Integer maxWordLength;
        @Nullable
        private Integer minDocFreq;
        @Nullable
        private Integer minTermFreq;
        @Nullable
        private Integer minWordLength;

        public final Builder maxDocFreq(@Nullable Integer value) {
            this.maxDocFreq = value;
            return this;
        }

        public final Builder maxNumTerms(@Nullable Integer value) {
            this.maxNumTerms = value;
            return this;
        }

        public final Builder maxTermFreq(@Nullable Integer value) {
            this.maxTermFreq = value;
            return this;
        }

        public final Builder maxWordLength(@Nullable Integer value) {
            this.maxWordLength = value;
            return this;
        }

        public final Builder minDocFreq(@Nullable Integer value) {
            this.minDocFreq = value;
            return this;
        }

        public final Builder minTermFreq(@Nullable Integer value) {
            this.minTermFreq = value;
            return this;
        }

        public final Builder minWordLength(@Nullable Integer value) {
            this.minWordLength = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Filter build() {
            this._checkSingleUse();
            return new Filter(this);
        }
    }
}

