/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.watch;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.watcher.support.WatcherUtils;

public interface Payload
extends ToXContentObject {
    public static final Simple EMPTY = new Simple(Collections.emptyMap());

    public Map<String, Object> data();

    public static class Simple
    implements Payload {
        private final Map<String, Object> data;

        public Simple() {
            this(Map.of());
        }

        public Simple(String key, Object value) {
            this(Map.of(key, value));
        }

        public Simple(Map<String, Object> data) {
            CollectionUtils.ensureNoSelfReferences(data, "watcher action payload");
            this.data = data;
        }

        @Override
        public Map<String, Object> data() {
            return this.data;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.map(this.data);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Simple simple = (Simple)o;
            return this.data.equals(simple.data);
        }

        public int hashCode() {
            return this.data.hashCode();
        }

        public String toString() {
            return "simple[" + Objects.toString(this.data) + "]";
        }
    }

    public static class XContent
    extends Simple {
        public XContent(ToXContentObject response, ToXContent.Params params) throws IOException {
            super(WatcherUtils.responseToData(response, params));
        }

        public XContent(ChunkedToXContentObject response, ToXContent.Params params) throws IOException {
            this(ChunkedToXContentObject.wrapAsToXContentObject(response), params);
        }
    }
}

