/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Objects;
import java.util.function.BiFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.ilm.ClusterStateActionStep;
import org.elasticsearch.xpack.core.ilm.Step;

public class ReplaceDataStreamBackingIndexStep
extends ClusterStateActionStep {
    public static final String NAME = "replace-datastream-backing-index";
    private static final Logger logger = LogManager.getLogger(ReplaceDataStreamBackingIndexStep.class);
    private final BiFunction<String, LifecycleExecutionState, String> targetIndexNameSupplier;

    public ReplaceDataStreamBackingIndexStep(Step.StepKey key, Step.StepKey nextStepKey, BiFunction<String, LifecycleExecutionState, String> targetIndexNameSupplier) {
        super(key, nextStepKey);
        this.targetIndexNameSupplier = targetIndexNameSupplier;
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    public BiFunction<String, LifecycleExecutionState, String> getTargetIndexNameSupplier() {
        return this.targetIndexNameSupplier;
    }

    @Override
    public ProjectState performAction(Index index, ProjectState projectState) {
        IndexMetadata originalIndexMetadata = projectState.metadata().index(index);
        if (originalIndexMetadata == null) {
            logger.debug("[{}] lifecycle action for index [{}] executed but index no longer exists", (Object)NAME, (Object)index.getName());
            return projectState;
        }
        String originalIndex = index.getName();
        String targetIndexName = this.targetIndexNameSupplier.apply(originalIndex, originalIndexMetadata.getLifecycleExecutionState());
        String policyName = originalIndexMetadata.getLifecyclePolicyName();
        IndexAbstraction indexAbstraction = (IndexAbstraction)projectState.metadata().getIndicesLookup().get(index.getName());
        assert (indexAbstraction != null) : "invalid cluster metadata. index [" + index.getName() + "] was not found";
        DataStream dataStream = indexAbstraction.getParentDataStream();
        if (dataStream == null) {
            String errorMessage = Strings.format("index [%s] is not part of a data stream. stopping execution of lifecycle [%s] until the index is added to a data stream", originalIndex, policyName);
            logger.debug(errorMessage);
            throw new IllegalStateException(errorMessage);
        }
        boolean isFailureStoreWriteIndex = index.equals(dataStream.getWriteFailureIndex());
        if (isFailureStoreWriteIndex || dataStream.getWriteIndex().equals(index)) {
            String errorMessage = Strings.format("index [%s] is the%s write index for data stream [%s], pausing ILM execution of lifecycle [%s] until this index is no longer the write index for the data stream via manual or automated rollover", originalIndex, isFailureStoreWriteIndex ? " failure store" : "", dataStream.getName(), policyName);
            logger.debug(errorMessage);
            throw new IllegalStateException(errorMessage);
        }
        IndexMetadata targetIndexMetadata = projectState.metadata().index(targetIndexName);
        if (targetIndexMetadata == null) {
            String errorMessage = Strings.format("target index [%s] doesn't exist. stopping execution of lifecycle [%s] for index [%s]", targetIndexName, policyName, originalIndex);
            logger.debug(errorMessage);
            throw new IllegalStateException(errorMessage);
        }
        DataStream updatedDataStream = dataStream.isFailureStoreIndex(originalIndex) ? dataStream.replaceFailureStoreIndex(index, targetIndexMetadata.getIndex()) : dataStream.replaceBackingIndex(index, targetIndexMetadata.getIndex());
        return projectState.updateProject(ProjectMetadata.builder(projectState.metadata()).put(updatedDataStream).build());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.targetIndexNameSupplier);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReplaceDataStreamBackingIndexStep other = (ReplaceDataStreamBackingIndexStep)obj;
        return super.equals(obj) && Objects.equals(this.targetIndexNameSupplier, other.targetIndexNameSupplier);
    }
}

