/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.ilm.OperationMode;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleMetadata;

public class LifecycleOperationMetadata
implements Metadata.ProjectCustom {
    public static final String TYPE = "lifecycle_operation";
    public static final ParseField ILM_OPERATION_MODE_FIELD = new ParseField("ilm_operation_mode", new String[0]);
    public static final ParseField SLM_OPERATION_MODE_FIELD = new ParseField("slm_operation_mode", new String[0]);
    public static final LifecycleOperationMetadata EMPTY = new LifecycleOperationMetadata(OperationMode.RUNNING, OperationMode.RUNNING);
    public static final ConstructingObjectParser<LifecycleOperationMetadata, Void> PARSER = new ConstructingObjectParser("lifecycle_operation", a -> new LifecycleOperationMetadata(OperationMode.valueOf((String)a[0]), OperationMode.valueOf((String)a[1])));
    private final OperationMode ilmOperationMode;
    private final OperationMode slmOperationMode;

    public LifecycleOperationMetadata(OperationMode ilmOperationMode, OperationMode slmOperationMode) {
        this.ilmOperationMode = ilmOperationMode;
        this.slmOperationMode = slmOperationMode;
    }

    public LifecycleOperationMetadata(StreamInput in) throws IOException {
        this.ilmOperationMode = in.readEnum(OperationMode.class);
        this.slmOperationMode = in.readEnum(OperationMode.class);
    }

    public static OperationMode currentILMMode(ProjectMetadata projectMetadata) {
        IndexLifecycleMetadata oldMetadata = (IndexLifecycleMetadata)projectMetadata.custom("index_lifecycle");
        LifecycleOperationMetadata currentMetadata = (LifecycleOperationMetadata)projectMetadata.custom(TYPE);
        return Optional.ofNullable(currentMetadata).map(LifecycleOperationMetadata::getILMOperationMode).orElse(Optional.ofNullable(oldMetadata).map(IndexLifecycleMetadata::getOperationMode).orElseGet(EMPTY::getILMOperationMode));
    }

    @Deprecated(forRemoval=true)
    public static OperationMode currentSLMMode(ClusterState state) {
        return LifecycleOperationMetadata.currentSLMMode(state.metadata().getProject());
    }

    public static OperationMode currentSLMMode(ProjectMetadata project) {
        SnapshotLifecycleMetadata oldMetadata = (SnapshotLifecycleMetadata)project.custom("snapshot_lifecycle");
        LifecycleOperationMetadata currentMetadata = (LifecycleOperationMetadata)project.custom(TYPE);
        return Optional.ofNullable(currentMetadata).map(LifecycleOperationMetadata::getSLMOperationMode).orElse(Optional.ofNullable(oldMetadata).map(SnapshotLifecycleMetadata::getOperationMode).orElseGet(EMPTY::getSLMOperationMode));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum(this.ilmOperationMode);
        out.writeEnum(this.slmOperationMode);
    }

    public OperationMode getILMOperationMode() {
        return this.ilmOperationMode;
    }

    public OperationMode getSLMOperationMode() {
        return this.slmOperationMode;
    }

    @Override
    public Diff<Metadata.ProjectCustom> diff(Metadata.ProjectCustom previousState) {
        return new LifecycleOperationMetadataDiff((LifecycleOperationMetadata)previousState, this);
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        ToXContent ilmModeField = (builder, params2) -> builder.field(ILM_OPERATION_MODE_FIELD.getPreferredName(), this.ilmOperationMode);
        ToXContent slmModeField = (builder, params2) -> builder.field(SLM_OPERATION_MODE_FIELD.getPreferredName(), this.slmOperationMode);
        return Iterators.forArray(new ToXContent[]{ilmModeField, slmModeField});
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_7_0;
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public EnumSet<Metadata.XContentContext> context() {
        return EnumSet.of(Metadata.XContentContext.API, Metadata.XContentContext.GATEWAY);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.ilmOperationMode, this.slmOperationMode});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        LifecycleOperationMetadata other = (LifecycleOperationMetadata)obj;
        return Objects.equals((Object)this.ilmOperationMode, (Object)other.ilmOperationMode) && Objects.equals((Object)this.slmOperationMode, (Object)other.slmOperationMode);
    }

    public String toString() {
        return Strings.toString(this, true, true);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), ILM_OPERATION_MODE_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), SLM_OPERATION_MODE_FIELD);
    }

    public static class LifecycleOperationMetadataDiff
    implements NamedDiff<Metadata.ProjectCustom> {
        final OperationMode ilmOperationMode;
        final OperationMode slmOperationMode;

        LifecycleOperationMetadataDiff(LifecycleOperationMetadata before, LifecycleOperationMetadata after) {
            this.ilmOperationMode = after.ilmOperationMode;
            this.slmOperationMode = after.slmOperationMode;
        }

        public LifecycleOperationMetadataDiff(StreamInput in) throws IOException {
            this.ilmOperationMode = in.readEnum(OperationMode.class);
            this.slmOperationMode = in.readEnum(OperationMode.class);
        }

        @Override
        public Metadata.ProjectCustom apply(Metadata.ProjectCustom part) {
            return new LifecycleOperationMetadata(this.ilmOperationMode, this.slmOperationMode);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeEnum(this.ilmOperationMode);
            out.writeEnum(this.slmOperationMode);
        }

        @Override
        public String getWriteableName() {
            return LifecycleOperationMetadata.TYPE;
        }

        @Override
        public TransportVersion getMinimalSupportedVersion() {
            return TransportVersions.V_8_7_0;
        }
    }
}

