/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.async;

import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.xpack.core.async.AsyncExecutionId;
import org.elasticsearch.xpack.core.async.AsyncResponse;
import org.elasticsearch.xpack.core.async.AsyncSearchSecurity;
import org.elasticsearch.xpack.core.async.AsyncTask;
import org.elasticsearch.xpack.core.async.AsyncTaskIndexService;
import org.elasticsearch.xpack.core.async.DeleteAsyncResultRequest;

public class DeleteAsyncResultsService {
    private static final Logger logger = LogManager.getLogger(DeleteAsyncResultsService.class);
    private final AsyncTaskIndexService<? extends AsyncResponse<?>> store;
    private final AsyncSearchSecurity security;
    private final TaskManager taskManager;

    public DeleteAsyncResultsService(AsyncTaskIndexService<? extends AsyncResponse<?>> store, TaskManager taskManager) {
        this.store = store;
        this.security = store.getSecurity();
        this.taskManager = taskManager;
    }

    public void deleteResponse(DeleteAsyncResultRequest request, ActionListener<AcknowledgedResponse> listener) {
        this.hasCancelTaskPrivilegeAsync(resp -> this.deleteResponseAsync(request, (boolean)resp, listener));
    }

    private void hasCancelTaskPrivilegeAsync(Consumer<Boolean> consumer) {
        this.security.currentUserHasCancelTaskPrivilege(consumer);
    }

    private void deleteResponseAsync(DeleteAsyncResultRequest request, boolean hasCancelTaskPrivilege, ActionListener<AcknowledgedResponse> listener) {
        try {
            AsyncTask task;
            AsyncExecutionId searchId = AsyncExecutionId.decode(request.getId());
            AsyncTask asyncTask = task = hasCancelTaskPrivilege ? AsyncTaskIndexService.getTask(this.taskManager, searchId, AsyncTask.class) : this.store.getTaskAndCheckAuthentication(this.taskManager, searchId, AsyncTask.class);
            if (task != null) {
                task.cancelTask(this.taskManager, () -> this.deleteResponseFromIndex(searchId, true, listener), "cancelled by user");
            } else if (hasCancelTaskPrivilege) {
                this.deleteResponseFromIndex(searchId, false, listener);
            } else {
                this.store.security.ensureAuthenticatedUserCanDeleteFromIndex(searchId, listener.delegateFailureAndWrap((l, res) -> this.deleteResponseFromIndex(searchId, false, (ActionListener<AcknowledgedResponse>)l)));
            }
        }
        catch (Exception exc) {
            listener.onFailure(new ResourceNotFoundException(request.getId(), new Object[0]));
        }
    }

    private void deleteResponseFromIndex(AsyncExecutionId taskId, boolean taskWasFound, ActionListener<AcknowledgedResponse> listener) {
        this.store.deleteResponse(taskId, ActionListener.wrap(resp -> {
            if (resp.status() == RestStatus.OK || taskWasFound) {
                listener.onResponse(AcknowledgedResponse.TRUE);
            } else {
                listener.onFailure(new ResourceNotFoundException(taskId.getEncoded(), new Object[0]));
            }
        }, exc -> {
            RestStatus status = ExceptionsHelper.status(ExceptionsHelper.unwrapCause(exc));
            if (status == RestStatus.NOT_FOUND && taskWasFound) {
                listener.onResponse(AcknowledgedResponse.TRUE);
            } else {
                logger.error(() -> "failed to clean async result [" + taskId.getEncoded() + "]", (Throwable)exc);
                listener.onFailure(new ResourceNotFoundException(taskId.getEncoded(), new Object[0]));
            }
        }));
    }
}

