/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.util.function.LongSupplier;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.script.ScriptContextStats;
import org.elasticsearch.script.ScriptStats;
import org.elasticsearch.script.TimeSeries;
import org.elasticsearch.script.TimeSeriesCounter;

public class ScriptMetrics {
    final CounterMetric compilationLimitTriggered = new CounterMetric();
    final TimeSeriesCounter compilations;
    final TimeSeriesCounter cacheEvictions;

    public ScriptMetrics(LongSupplier timeProvider) {
        this.compilations = new TimeSeriesCounter(timeProvider);
        this.cacheEvictions = new TimeSeriesCounter(timeProvider);
    }

    public void onCompilation() {
        this.compilations.inc();
    }

    public void onCacheEviction() {
        this.cacheEvictions.inc();
    }

    public void onCompilationLimit() {
        this.compilationLimitTriggered.inc();
    }

    public ScriptStats stats() {
        TimeSeries compilationsTimeSeries = this.compilations.timeSeries();
        TimeSeries cacheEvictionsTimeSeries = this.cacheEvictions.timeSeries();
        return new ScriptStats(compilationsTimeSeries.total, cacheEvictionsTimeSeries.total, this.compilationLimitTriggered.count(), compilationsTimeSeries, cacheEvictionsTimeSeries);
    }

    public ScriptContextStats stats(String context) {
        TimeSeries compilationsTimeSeries = this.compilations.timeSeries();
        TimeSeries cacheEvictionsTimeSeries = this.cacheEvictions.timeSeries();
        return new ScriptContextStats(context, this.compilationLimitTriggered.count(), compilationsTimeSeries, cacheEvictionsTimeSeries);
    }
}

