/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.util.Map;
import java.util.function.DoubleConsumer;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.ArrayUtil;
import org.elasticsearch.index.mapper.OnScriptError;
import org.elasticsearch.script.AbstractFieldScript;
import org.elasticsearch.script.CompositeFieldScript;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptFactory;
import org.elasticsearch.search.lookup.SearchLookup;

public abstract class DoubleFieldScript
extends AbstractFieldScript {
    public static final ScriptContext<Factory> CONTEXT = DoubleFieldScript.newContext("double_field", Factory.class);
    public static final Factory PARSE_FROM_SOURCE = new Factory(){

        @Override
        public LeafFactory newFactory(String field, Map<String, Object> params, SearchLookup lookup, OnScriptError onScriptError) {
            return ctx -> new DoubleFieldScript(this, field, params, lookup, OnScriptError.FAIL, ctx){

                @Override
                public void execute() {
                    this.emitFromSource();
                }
            };
        }

        @Override
        public boolean isResultDeterministic() {
            return true;
        }
    };
    public static final String[] PARAMETERS = new String[0];
    private double[] values = new double[1];
    private int count;

    public static Factory leafAdapter(Function<SearchLookup, CompositeFieldScript.LeafFactory> parentFactory) {
        return (leafFieldName, params, searchLookup, onScriptError) -> {
            CompositeFieldScript.LeafFactory parentLeafFactory = (CompositeFieldScript.LeafFactory)parentFactory.apply(searchLookup);
            return ctx -> {
                final CompositeFieldScript compositeFieldScript = parentLeafFactory.newInstance(ctx);
                return new DoubleFieldScript(leafFieldName, params, searchLookup, onScriptError, ctx){

                    @Override
                    public void setDocument(int docId) {
                        compositeFieldScript.setDocument(docId);
                    }

                    @Override
                    public void execute() {
                        this.emitFromCompositeScript(compositeFieldScript);
                    }
                };
            };
        };
    }

    public DoubleFieldScript(String fieldName, Map<String, Object> params, SearchLookup searchLookup, OnScriptError onScriptError, LeafReaderContext ctx) {
        super(fieldName, params, searchLookup, ctx, onScriptError);
    }

    @Override
    protected void prepareExecute() {
        this.count = 0;
    }

    public final void runForDoc(int docId, DoubleConsumer consumer) {
        this.runForDoc(docId);
        for (int i = 0; i < this.count; ++i) {
            consumer.accept(this.values[i]);
        }
    }

    public final double[] values() {
        return this.values;
    }

    public final int count() {
        return this.count;
    }

    @Override
    protected void emitFromObject(Object v) {
        if (v instanceof Number) {
            this.emit(((Number)v).doubleValue());
        } else if (v instanceof String) {
            try {
                this.emit(Double.parseDouble((String)v));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public final void emit(double v) {
        if (this.values.length < this.count + 1) {
            this.values = ArrayUtil.grow(this.values, this.count + 1);
        }
        this.values[this.count++] = v;
    }

    public static interface Factory
    extends ScriptFactory {
        public LeafFactory newFactory(String var1, Map<String, Object> var2, SearchLookup var3, OnScriptError var4);
    }

    public static interface LeafFactory {
        public DoubleFieldScript newInstance(LeafReaderContext var1);
    }

    public static class Emit {
        private final DoubleFieldScript script;

        public Emit(DoubleFieldScript script) {
            this.script = script;
        }

        public void emit(double v) {
            this.script.checkMaxSize(this.script.count());
            this.script.emit(v);
        }
    }
}

