/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;

@ServerlessScope(value=Scope.PUBLIC)
public class RestPutMappingAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/{index}/_mapping/"), new RestHandler.Route(RestRequest.Method.PUT, "/{index}/_mapping/"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_mappings/"), new RestHandler.Route(RestRequest.Method.PUT, "/{index}/_mappings/"));
    }

    @Override
    public String getName() {
        return "put_mapping_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        PutMappingRequest putMappingRequest = new PutMappingRequest(indices);
        Map<String, Object> sourceAsMap = XContentHelper.convertToMap(request.requiredContent(), false, request.getXContentType()).v2();
        if (MapperService.isMappingSourceTyped("_doc", sourceAsMap)) {
            throw new IllegalArgumentException("Types cannot be provided in put mapping requests");
        }
        putMappingRequest.source(sourceAsMap);
        putMappingRequest.ackTimeout(RestUtils.getAckTimeout(request));
        putMappingRequest.masterNodeTimeout(RestUtils.getMasterNodeTimeout(request));
        putMappingRequest.indicesOptions(IndicesOptions.fromRequest(request, putMappingRequest.indicesOptions()));
        putMappingRequest.writeIndexOnly(request.paramAsBoolean("write_index_only", false));
        return channel -> client.admin().indices().putMapping(putMappingRequest, new RestToXContentListener<AcknowledgedResponse>((RestChannel)channel));
    }

    private static Map<String, Object> prepareV7Mappings(boolean includeTypeName, Map<String, Object> mappings) {
        if (includeTypeName && mappings != null && mappings.size() == 1) {
            String typeName = mappings.keySet().iterator().next();
            if (!Strings.hasText(typeName)) {
                throw new IllegalArgumentException("name cannot be empty string");
            }
            Map typelessMappings = (Map)mappings.get(typeName);
            return typelessMappings;
        }
        return mappings;
    }
}

