/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery;

import java.io.IOException;
import org.elasticsearch.cluster.coordination.PendingClusterStateStats;
import org.elasticsearch.cluster.coordination.PublishClusterStateStats;
import org.elasticsearch.cluster.service.ClusterApplierRecordingService;
import org.elasticsearch.cluster.service.ClusterStateUpdateStats;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class DiscoveryStats
implements Writeable,
ToXContentFragment {
    private final PendingClusterStateStats queueStats;
    private final PublishClusterStateStats publishStats;
    private final ClusterStateUpdateStats clusterStateUpdateStats;
    private final ClusterApplierRecordingService.Stats applierRecordingStats;

    public DiscoveryStats(PendingClusterStateStats queueStats, PublishClusterStateStats publishStats, ClusterStateUpdateStats clusterStateUpdateStats, ClusterApplierRecordingService.Stats applierRecordingStats) {
        this.queueStats = queueStats;
        this.publishStats = publishStats;
        this.clusterStateUpdateStats = clusterStateUpdateStats;
        this.applierRecordingStats = applierRecordingStats;
    }

    public DiscoveryStats(StreamInput in) throws IOException {
        this.queueStats = in.readOptionalWriteable(PendingClusterStateStats::new);
        this.publishStats = in.readOptionalWriteable(PublishClusterStateStats::new);
        this.clusterStateUpdateStats = in.readOptionalWriteable(ClusterStateUpdateStats::new);
        this.applierRecordingStats = in.readOptionalWriteable(ClusterApplierRecordingService.Stats::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable(this.queueStats);
        out.writeOptionalWriteable(this.publishStats);
        out.writeOptionalWriteable(this.clusterStateUpdateStats);
        out.writeOptionalWriteable(this.applierRecordingStats);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("discovery");
        if (this.queueStats != null) {
            this.queueStats.toXContent(builder, params);
        }
        if (this.publishStats != null) {
            this.publishStats.toXContent(builder, params);
        }
        if (this.clusterStateUpdateStats != null) {
            this.clusterStateUpdateStats.toXContent(builder, params);
        }
        if (this.applierRecordingStats != null) {
            this.applierRecordingStats.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }

    public ClusterStateUpdateStats getClusterStateUpdateStats() {
        return this.clusterStateUpdateStats;
    }

    public PendingClusterStateStats getQueueStats() {
        return this.queueStats;
    }

    public PublishClusterStateStats getPublishStats() {
        return this.publishStats;
    }

    public ClusterApplierRecordingService.Stats getApplierRecordingStats() {
        return this.applierRecordingStats;
    }

    static final class Fields {
        static final String DISCOVERY = "discovery";

        Fields() {
        }
    }
}

