/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.recycler;

import com.carrotsearch.hppc.BitMixer;
import java.util.ArrayDeque;
import org.elasticsearch.common.recycler.ConcurrentDequeRecycler;
import org.elasticsearch.common.recycler.DequeRecycler;
import org.elasticsearch.common.recycler.FilterRecycler;
import org.elasticsearch.common.recycler.NoneRecycler;
import org.elasticsearch.common.recycler.Recycler;

public final class Recyclers
extends Enum<Recyclers> {
    private static final /* synthetic */ Recyclers[] $VALUES;

    public static Recyclers[] values() {
        return (Recyclers[])$VALUES.clone();
    }

    public static Recyclers valueOf(String name) {
        return Enum.valueOf(Recyclers.class, name);
    }

    public static <T> Recycler<T> none(Recycler.C<T> c) {
        return new NoneRecycler<T>(c);
    }

    public static <T> Recycler<T> concurrentDeque(Recycler.C<T> c, int limit) {
        return new ConcurrentDequeRecycler<T>(c, limit);
    }

    public static <T> Recycler<T> deque(Recycler.C<T> c, int limit) {
        return new DequeRecycler<T>(c, new ArrayDeque(), limit);
    }

    public static <T> Recycler.Factory<T> dequeFactory(Recycler.C<T> c, int limit) {
        return () -> Recyclers.deque(c, limit);
    }

    public static <T> Recycler<T> locked(final Recycler<T> recycler) {
        return new FilterRecycler<T>(){
            private final Object lock = new Object();

            @Override
            protected Recycler<T> getDelegate() {
                return recycler;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Recycler.V<T> obtain() {
                Object object = this.lock;
                synchronized (object) {
                    return super.obtain();
                }
            }

            @Override
            protected Recycler.V<T> wrap(final Recycler.V<T> delegate) {
                return new Recycler.V<T>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void close() {
                        Object object = lock;
                        synchronized (object) {
                            delegate.close();
                        }
                    }

                    @Override
                    public T v() {
                        return delegate.v();
                    }

                    @Override
                    public boolean isRecycled() {
                        return delegate.isRecycled();
                    }
                };
            }

            @Override
            public int pageSize() {
                return this.getDelegate().pageSize();
            }
        };
    }

    public static <T> Recycler<T> concurrent(final Recycler.Factory<T> factory, final int concurrencyLevel) {
        if (concurrencyLevel < 1) {
            throw new IllegalArgumentException("concurrencyLevel must be >= 1");
        }
        if (concurrencyLevel == 1) {
            return Recyclers.locked(factory.build());
        }
        return new FilterRecycler<T>(){
            private final Recycler<T>[] recyclers;
            {
                Recycler[] recyclers = new Recycler[concurrencyLevel];
                this.recyclers = recyclers;
                for (int i = 0; i < concurrencyLevel; ++i) {
                    recyclers[i] = Recyclers.locked(factory.build());
                }
            }

            int slot() {
                long id = Thread.currentThread().getId();
                int slot = (int)BitMixer.mix64((long)id);
                slot &= Integer.MAX_VALUE;
                return slot %= concurrencyLevel;
            }

            @Override
            protected Recycler<T> getDelegate() {
                return this.recyclers[this.slot()];
            }

            @Override
            public int pageSize() {
                return this.recyclers[this.slot()].pageSize();
            }
        };
    }

    private static /* synthetic */ Recyclers[] $values() {
        return new Recyclers[0];
    }

    static {
        $VALUES = Recyclers.$values();
    }
}

