/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public record NodeAllocationStats(int shards, int undesiredShards, double forecastedIngestLoad, long forecastedDiskUsage, long currentDiskUsage) implements Writeable,
ToXContentFragment
{
    public NodeAllocationStats(StreamInput in) throws IOException {
        this(in.readVInt(), in.readVInt(), in.readDouble(), in.readVLong(), in.readVLong());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.shards);
        out.writeVInt(this.undesiredShards);
        out.writeDouble(this.forecastedIngestLoad);
        out.writeVLong(this.forecastedDiskUsage);
        out.writeVLong(this.currentDiskUsage);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject("allocations").field("shards", this.shards).field("undesired_shards", this.undesiredShards).field("forecasted_ingest_load", this.forecastedIngestLoad).humanReadableField("forecasted_disk_usage_in_bytes", "forecasted_disk_usage", ByteSizeValue.ofBytes(this.forecastedDiskUsage)).humanReadableField("current_disk_usage_in_bytes", "current_disk_usage", ByteSizeValue.ofBytes(this.currentDiskUsage)).endObject();
    }
}

