/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.project;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.project.ProjectIdResolver;
import org.elasticsearch.core.CheckedRunnable;

public interface ProjectResolver
extends ProjectIdResolver {
    default public ProjectMetadata getProjectMetadata(Metadata metadata) {
        return metadata.getProject(this.getProjectId());
    }

    default public ProjectMetadata getProjectMetadata(ClusterState clusterState) {
        return this.getProjectMetadata(clusterState.metadata());
    }

    default public boolean hasProject(ClusterState clusterState) {
        return this.hasProject(clusterState.metadata());
    }

    default public boolean hasProject(Metadata metadata) {
        return metadata.hasProject(this.getProjectId());
    }

    default public ProjectState getProjectState(ClusterState clusterState) {
        ProjectId id = this.getProjectId();
        ProjectState projectState = clusterState.projectState(id);
        if (!1.$assertionsDisabled && projectState == null) {
            throw new AssertionError((Object)("Received null project state for [" + String.valueOf(id) + "] from " + String.valueOf(clusterState)));
        }
        return projectState;
    }

    default public Collection<ProjectId> getProjectIds(ClusterState clusterState) {
        ProjectId projectId = Objects.requireNonNull(this.getProjectId());
        if (!clusterState.metadata().hasProject(projectId)) {
            throw new IllegalArgumentException("Project [" + String.valueOf(projectId) + "] does not exist");
        }
        return Set.of(this.getProjectId());
    }

    public <E extends Exception> void executeOnProject(ProjectId var1, CheckedRunnable<E> var2) throws E;

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

