/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.synonyms;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.synonyms.SynonymRule;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class GetSynonymRuleAction
extends ActionType<Response> {
    public static final GetSynonymRuleAction INSTANCE = new GetSynonymRuleAction();
    public static final String NAME = "cluster:admin/synonym_rules/get";

    public GetSynonymRuleAction() {
        super(NAME);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final SynonymRule synonymRule;

        public Response(StreamInput in) throws IOException {
            this.synonymRule = new SynonymRule(in);
        }

        public Response(SynonymRule synonymRule) {
            this.synonymRule = synonymRule;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.synonymRule.writeTo(out);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            this.synonymRule.toXContent(builder, params);
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)o;
            return Objects.equals(this.synonymRule, response.synonymRule);
        }

        public int hashCode() {
            return Objects.hash(this.synonymRule);
        }
    }

    public static class Request
    extends LegacyActionRequest {
        private final String synonymsSetId;
        private final String synonymRuleId;

        public Request(StreamInput in) throws IOException {
            super(in);
            this.synonymsSetId = in.readString();
            this.synonymRuleId = in.readString();
        }

        public Request(String synonymsSetId, String synonymRuleId) {
            this.synonymsSetId = synonymsSetId;
            this.synonymRuleId = synonymRuleId;
        }

        @Override
        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (Strings.isNullOrEmpty(this.synonymsSetId)) {
                validationException = ValidateActions.addValidationError("synonyms set must be specified", validationException);
            }
            if (Strings.isNullOrEmpty(this.synonymRuleId)) {
                validationException = ValidateActions.addValidationError("synonym rule id must be specified", validationException);
            }
            return validationException;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.synonymsSetId);
            out.writeString(this.synonymRuleId);
        }

        public String synonymsSetId() {
            return this.synonymsSetId;
        }

        public String synonymRuleId() {
            return this.synonymRuleId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Objects.equals(this.synonymsSetId, request.synonymsSetId) && Objects.equals(this.synonymRuleId, request.synonymRuleId);
        }

        public int hashCode() {
            return Objects.hash(this.synonymsSetId, this.synonymRuleId);
        }
    }
}

