/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logstash.filters.elasticintegration.geoip;

import co.elastic.logstash.filters.elasticintegration.geoip.ConstantIpDatabaseHolder;
import co.elastic.logstash.filters.elasticintegration.geoip.IpDatabaseAdapter;
import co.elastic.logstash.filters.elasticintegration.geoip.IpDatabaseHolder;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.ingest.geoip.IpDatabase;

public class IpDatabaseProvider
implements org.elasticsearch.ingest.geoip.IpDatabaseProvider,
Closeable {
    private static final Logger LOGGER = LogManager.getLogger(IpDatabaseProvider.class);
    private final Map<String, IpDatabaseHolder> databaseMap;

    IpDatabaseProvider(Map<String, IpDatabaseHolder> databaseMap) {
        this.databaseMap = Map.copyOf(databaseMap);
    }

    @Override
    public Boolean isValid(ProjectId projectId, String databaseIdentifierFileName) {
        IpDatabaseHolder holder = this.getDatabaseHolder(databaseIdentifierFileName);
        return Objects.nonNull(holder) && holder.isValid();
    }

    @Override
    public IpDatabase getDatabase(ProjectId projectId, String databaseIdentifierFileName) {
        IpDatabaseHolder holder = this.getDatabaseHolder(databaseIdentifierFileName);
        if (Objects.isNull(holder)) {
            return null;
        }
        return holder.getDatabase();
    }

    IpDatabaseHolder getDatabaseHolder(String databaseIdentifierFileName) {
        return this.databaseMap.get(databaseIdentifierFileName);
    }

    @Override
    public void close() throws IOException {
        this.databaseMap.forEach((name, holder) -> {
            if (holder instanceof Closeable) {
                IOUtils.closeWhileHandlingException((Closeable)((Object)holder));
            }
        });
    }

    public static class Builder {
        private final Map<String, IpDatabaseHolder> databaseMap = new HashMap<String, IpDatabaseHolder>();

        public synchronized Builder setDatabaseHolder(String identifierFileName, IpDatabaseHolder holder) {
            IpDatabaseHolder previous = this.databaseMap.put(identifierFileName, holder);
            if (Objects.nonNull(previous)) {
                LOGGER.warn(String.format("de-registered previous entry for `%s`: %s", identifierFileName, previous.info()));
                if (previous instanceof Closeable) {
                    IOUtils.closeWhileHandlingException((Closeable)((Object)previous));
                }
            }
            return this;
        }

        public Builder discoverDatabases(File directory) throws IOException {
            List<Path> databases = Files.find(directory.toPath(), 3, Builder::isMaxMindDatabase, new FileVisitOption[0]).toList();
            if (databases.isEmpty()) {
                LOGGER.warn(String.format("Failed to find Maxmind DB files in `%s`", directory));
            } else {
                for (Path database : databases) {
                    try {
                        IpDatabaseAdapter adapter = IpDatabaseAdapter.defaultForPath(database);
                        ConstantIpDatabaseHolder holder = new ConstantIpDatabaseHolder(adapter);
                        this.setDatabaseHolder(database.getFileName().toString(), holder);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            return this;
        }

        private static boolean isMaxMindDatabase(Path path, BasicFileAttributes basicFileAttributes) {
            return basicFileAttributes.isRegularFile() && path.getFileName().toString().endsWith(".mmdb");
        }

        public final IpDatabaseProvider build() {
            return new IpDatabaseProvider(this.databaseMap);
        }
    }
}

