/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logstash.filters.elasticintegration;

import co.elastic.logstash.api.Event;
import co.elastic.logstash.api.FilterMatchListener;
import co.elastic.logstash.filters.elasticintegration.DatastreamEventToIndexNameResolver;
import co.elastic.logstash.filters.elasticintegration.ElasticsearchIndexNameToPipelineNameResolver;
import co.elastic.logstash.filters.elasticintegration.ElasticsearchPipelineConfigurationResolver;
import co.elastic.logstash.filters.elasticintegration.EventProcessor;
import co.elastic.logstash.filters.elasticintegration.EventToIndexNameResolver;
import co.elastic.logstash.filters.elasticintegration.EventToPipelineNameResolver;
import co.elastic.logstash.filters.elasticintegration.IndexNameToPipelineNameResolver;
import co.elastic.logstash.filters.elasticintegration.IngestPipeline;
import co.elastic.logstash.filters.elasticintegration.IngestPipelineFactory;
import co.elastic.logstash.filters.elasticintegration.IngestPipelineResolver;
import co.elastic.logstash.filters.elasticintegration.PipelineConfigurationResolver;
import co.elastic.logstash.filters.elasticintegration.PluginConfiguration;
import co.elastic.logstash.filters.elasticintegration.SimpleIngestPipelineResolver;
import co.elastic.logstash.filters.elasticintegration.SprintfTemplateEventToPipelineNameResolver;
import co.elastic.logstash.filters.elasticintegration.ingest.RedactPlugin;
import co.elastic.logstash.filters.elasticintegration.ingest.SafeSubsetIngestPlugin;
import co.elastic.logstash.filters.elasticintegration.ingest.SetSecurityUserProcessor;
import co.elastic.logstash.filters.elasticintegration.ingest.SingleProcessorIngestPlugin;
import co.elastic.logstash.filters.elasticintegration.resolver.CacheReloadService;
import co.elastic.logstash.filters.elasticintegration.resolver.CachingResolver;
import co.elastic.logstash.filters.elasticintegration.resolver.ResolverCache;
import co.elastic.logstash.filters.elasticintegration.resolver.SimpleCachingResolver;
import co.elastic.logstash.filters.elasticintegration.resolver.SimpleResolverCache;
import co.elastic.logstash.filters.elasticintegration.util.Exceptions;
import co.elastic.logstash.filters.elasticintegration.util.PluginContext;
import com.google.common.util.concurrent.AbstractScheduledService;
import com.google.common.util.concurrent.ServiceManager;
import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.env.Environment;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.ingest.LogstashInternalBridge;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.ingest.common.IngestCommonPlugin;
import org.elasticsearch.ingest.common.ProcessorsWhitelistExtension;
import org.elasticsearch.ingest.useragent.IngestUserAgentPlugin;
import org.elasticsearch.painless.PainlessPlugin;
import org.elasticsearch.painless.spi.PainlessExtension;
import org.elasticsearch.plugins.ExtensiblePlugin;
import org.elasticsearch.plugins.IngestPlugin;
import org.elasticsearch.script.IngestConditionalScript;
import org.elasticsearch.script.IngestScript;
import org.elasticsearch.script.ScriptEngine;
import org.elasticsearch.script.ScriptModule;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.mustache.MustacheScriptEngine;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.constantkeyword.ConstantKeywordPainlessExtension;
import org.elasticsearch.xpack.spatial.SpatialPainlessExtension;
import org.elasticsearch.xpack.wildcard.WildcardPainlessExtension;

public class EventProcessorBuilder {
    static final Duration CACHE_MAXIMUM_AGE = Duration.ofHours(24L);
    static final Duration CACHE_RELOAD_FREQUENCY = Duration.ofSeconds(60L);
    private EventToPipelineNameResolver eventToPipelineNameResolver;
    private EventToIndexNameResolver eventToIndexNameResolver;
    private IndexNameToPipelineNameResolver indexNameToPipelineNameResolver;
    private Supplier<ResolverCache<String, String>> pipelineNameResolverCacheSupplier;
    private PipelineConfigurationResolver pipelineConfigurationResolver;
    private Supplier<ResolverCache<String, IngestPipeline>> ingestPipelineResolverCacheSupplier;
    private FilterMatchListener filterMatchListener;
    private final List<Supplier<IngestPlugin>> ingestPlugins = new ArrayList<Supplier<IngestPlugin>>();

    private static <K, V> Supplier<ResolverCache<K, V>> defaultCacheSupplier(String description) {
        return () -> new SimpleResolverCache(description, SimpleResolverCache.Configuration.PERMANENT);
    }

    public static EventProcessorBuilder fromElasticsearch(RestClient elasticsearchRestClient, PluginConfiguration pluginConfiguration) {
        EventProcessorBuilder builder = new EventProcessorBuilder();
        if (pluginConfiguration.pipelineNameTemplate().isPresent()) {
            builder.setEventPipelineNameResolver(SprintfTemplateEventToPipelineNameResolver.from(pluginConfiguration.pipelineNameTemplate().get()));
        }
        builder.setEventIndexNameResolver(new DatastreamEventToIndexNameResolver());
        builder.setIndexNamePipelineNameResolver(new ElasticsearchIndexNameToPipelineNameResolver(elasticsearchRestClient));
        builder.setPipelineNameResolverCacheConfig(CACHE_MAXIMUM_AGE, CACHE_MAXIMUM_AGE);
        builder.setPipelineConfigurationResolver(new ElasticsearchPipelineConfigurationResolver(elasticsearchRestClient));
        builder.setIngestPipelineResolverCacheConfig(CACHE_MAXIMUM_AGE, CACHE_MAXIMUM_AGE);
        return builder;
    }

    public EventProcessorBuilder() {
        this.addProcessorsFromPlugin(IngestCommonPlugin::new, Set.of("append", "bytes", "community_id", "convert", "csv", "date_index_name", "date", "dissect", "dot_expander", "drop", "fail", "fingerprint", "foreach", "grok", "gsub", "html_strip", "join", "json", "kv", "lowercase", "network_direction", "registered_domain", "remove", "rename", "reroute", "script", "set", "sort", "split", "terminate", "trim", "urldecode", "uppercase", "uri_parts"));
        this.addProcessorsFromPlugin(IngestUserAgentPlugin::new);
        this.addProcessorsFromPlugin(RedactPlugin::new);
        this.addProcessor("set_security_user", SetSecurityUserProcessor.Factory::new);
    }

    public synchronized EventProcessorBuilder setPipelineConfigurationResolver(PipelineConfigurationResolver pipelineConfigurationResolver) {
        if (Objects.nonNull(this.pipelineConfigurationResolver)) {
            throw new IllegalStateException("pipelineConfigurationResolver already set");
        }
        this.pipelineConfigurationResolver = pipelineConfigurationResolver;
        return this;
    }

    public EventProcessorBuilder setIngestPipelineResolverCacheConfig(Duration maxHitTtl, Duration maxMissTtl) {
        return this.setIngestPipelineResolverCacheSupplier(() -> new SimpleResolverCache("pipeline", new SimpleResolverCache.Configuration(maxHitTtl, maxMissTtl)));
    }

    public synchronized EventProcessorBuilder setIngestPipelineResolverCacheSupplier(Supplier<ResolverCache<String, IngestPipeline>> cacheSupplier) {
        this.ingestPipelineResolverCacheSupplier = cacheSupplier;
        return this;
    }

    public synchronized EventProcessorBuilder setEventPipelineNameResolver(EventToPipelineNameResolver eventToPipelineNameResolver) {
        if (Objects.nonNull(this.eventToPipelineNameResolver)) {
            throw new IllegalStateException("eventToPipelineNameResolver already set");
        }
        this.eventToPipelineNameResolver = eventToPipelineNameResolver;
        return this;
    }

    public synchronized EventProcessorBuilder setEventIndexNameResolver(EventToIndexNameResolver eventToIndexNameResolver) {
        if (Objects.nonNull(this.eventToIndexNameResolver)) {
            throw new IllegalStateException("eventToIndexNameResolver already set");
        }
        this.eventToIndexNameResolver = eventToIndexNameResolver;
        return this;
    }

    public EventProcessorBuilder setPipelineNameResolverCacheConfig(Duration maxHitTtl, Duration maxMissTtl) {
        return this.setPipelineNameResolverCacheSupplier(() -> new SimpleResolverCache("pipeline-name", new SimpleResolverCache.Configuration(maxHitTtl, maxMissTtl)));
    }

    public synchronized EventProcessorBuilder setPipelineNameResolverCacheSupplier(Supplier<ResolverCache<String, String>> cacheSupplier) {
        this.pipelineNameResolverCacheSupplier = cacheSupplier;
        return this;
    }

    public synchronized EventProcessorBuilder setIndexNamePipelineNameResolver(IndexNameToPipelineNameResolver indexNameToPipelineNameResolver) {
        if (Objects.nonNull(this.indexNameToPipelineNameResolver)) {
            throw new IllegalStateException("indexNameToPipelineNameResolver already set");
        }
        this.indexNameToPipelineNameResolver = indexNameToPipelineNameResolver;
        return this;
    }

    public EventProcessorBuilder setFilterMatchListener(Consumer<Event> filterMatchListener) {
        return this.setFilterMatchListener(filterMatchListener::accept);
    }

    private synchronized EventProcessorBuilder setFilterMatchListener(FilterMatchListener filterMatchListener) {
        if (Objects.nonNull(this.filterMatchListener)) {
            throw new IllegalStateException("filterMatchListener already set");
        }
        this.filterMatchListener = filterMatchListener;
        return this;
    }

    public EventProcessorBuilder addProcessor(String type, Supplier<Processor.Factory> processorFactorySupplier) {
        return this.addProcessorsFromPlugin(SingleProcessorIngestPlugin.of(type, processorFactorySupplier));
    }

    public EventProcessorBuilder addProcessorsFromPlugin(Supplier<IngestPlugin> pluginSupplier, Set<String> requiredProcessors) {
        return this.addProcessorsFromPlugin(SafeSubsetIngestPlugin.safeSubset(pluginSupplier, requiredProcessors));
    }

    public synchronized EventProcessorBuilder addProcessorsFromPlugin(Supplier<IngestPlugin> pluginSupplier) {
        this.ingestPlugins.add(pluginSupplier);
        return this;
    }

    public synchronized EventProcessor build(PluginContext pluginContext) {
        Objects.requireNonNull(this.pipelineConfigurationResolver, "pipeline configuration resolver is REQUIRED");
        Objects.requireNonNull(this.eventToIndexNameResolver, "event index name resolver is REQUIRED");
        Objects.requireNonNull(this.indexNameToPipelineNameResolver, "pipeline name resolver is REQUIRED");
        Settings settings = Settings.builder().put("path.home", "/").put("node.name", "logstash.filter.elastic_integration." + pluginContext.pluginId()).put("ingest.grok.watchdog.interval", "1s").put("ingest.grok.watchdog.max_execution_time", "1s").build();
        ArrayList<Closeable> resourcesToClose = new ArrayList<Closeable>();
        try {
            IndexNameToPipelineNameResolver indexNameToPipelineNameResolver;
            ArrayList<CacheReloadService> services = new ArrayList<CacheReloadService>();
            ThreadPool threadPool = LogstashInternalBridge.createThreadPool(settings);
            resourcesToClose.add(() -> ThreadPool.terminate(threadPool, 10L, TimeUnit.SECONDS));
            ScriptService scriptService = EventProcessorBuilder.initScriptService(settings, threadPool);
            resourcesToClose.add(scriptService);
            Environment env = new Environment(settings, null);
            Processor.Parameters processorParameters = new Processor.Parameters(env, scriptService, null, threadPool.getThreadContext(), threadPool::relativeTimeInMillis, (delay, command) -> threadPool.schedule((Runnable)command, TimeValue.timeValueMillis(delay), threadPool.generic()), null, null, threadPool.generic()::execute, IngestService.createGrokThreadWatchdog(env, threadPool));
            IngestPipelineFactory ingestPipelineFactory = new IngestPipelineFactory(scriptService);
            for (Supplier<IngestPlugin> ingestPluginSupplier : this.ingestPlugins) {
                IngestPlugin ingestPlugin = ingestPluginSupplier.get();
                if (ingestPlugin instanceof Closeable) {
                    Closeable closeableIngestPlugin = (Closeable)((Object)ingestPlugin);
                    resourcesToClose.add(closeableIngestPlugin);
                }
                Map<String, Processor.Factory> processorFactories = ingestPlugin.getProcessors(processorParameters);
                ingestPipelineFactory = ingestPipelineFactory.withProcessors(processorFactories);
            }
            ResolverCache ingestPipelineCache = Optional.ofNullable(this.ingestPipelineResolverCacheSupplier).orElse(EventProcessorBuilder.defaultCacheSupplier("ingest-pipeline")).get();
            CachingResolver cachingInternalPipelineResolver = new SimpleIngestPipelineResolver(this.pipelineConfigurationResolver, ingestPipelineFactory).withCache(ingestPipelineCache);
            services.add(CacheReloadService.newManaged(pluginContext, ((SimpleCachingResolver)cachingInternalPipelineResolver).getReloader(), AbstractScheduledService.Scheduler.newFixedRateSchedule((Duration)CACHE_RELOAD_FREQUENCY, (Duration)CACHE_RELOAD_FREQUENCY)));
            FilterMatchListener filterMatchListener = Objects.requireNonNullElse(this.filterMatchListener, event -> {});
            IndexNameToPipelineNameResolver indexNameToPipelineNameResolver2 = this.indexNameToPipelineNameResolver;
            if (indexNameToPipelineNameResolver2 instanceof IndexNameToPipelineNameResolver.Cacheable) {
                IndexNameToPipelineNameResolver.Cacheable cacheable = (IndexNameToPipelineNameResolver.Cacheable)indexNameToPipelineNameResolver2;
                ResolverCache pipelineNameCache = Optional.ofNullable(this.pipelineNameResolverCacheSupplier).orElse(EventProcessorBuilder.defaultCacheSupplier("pipeline-name")).get();
                CachingResolver cachingPipelineNameResolver = cacheable.withCache(pipelineNameCache);
                services.add(CacheReloadService.newManaged(pluginContext, cachingPipelineNameResolver.getReloader(), AbstractScheduledService.Scheduler.newFixedRateSchedule((Duration)CACHE_RELOAD_FREQUENCY, (Duration)CACHE_RELOAD_FREQUENCY)));
                indexNameToPipelineNameResolver = cachingPipelineNameResolver::resolve;
            } else {
                indexNameToPipelineNameResolver = this.indexNameToPipelineNameResolver;
            }
            ServiceManager serviceManager = new ServiceManager(services);
            serviceManager.startAsync();
            resourcesToClose.add(() -> {
                serviceManager.stopAsync();
                serviceManager.awaitStopped();
            });
            return new EventProcessor(filterMatchListener, (IngestPipelineResolver)((Object)cachingInternalPipelineResolver), this.eventToPipelineNameResolver, this.eventToIndexNameResolver, indexNameToPipelineNameResolver, resourcesToClose);
        }
        catch (Exception e) {
            IOUtils.closeWhileHandlingException(resourcesToClose);
            throw Exceptions.wrap(e, "Failed to build EventProcessor");
        }
    }

    private static ScriptService initScriptService(Settings settings, ThreadPool threadPool) throws IOException {
        HashMap<String, ScriptEngine> engines = new HashMap<String, ScriptEngine>();
        engines.put("painless", EventProcessorBuilder.getPainlessScriptEngine(settings));
        engines.put("mustache", new MustacheScriptEngine(settings));
        return new ScriptService(settings, engines, ScriptModule.CORE_CONTEXTS, threadPool::absoluteTimeInMillis);
    }

    private static ScriptEngine getPainlessScriptEngine(Settings settings) throws IOException {
        try (PainlessPlugin painlessPlugin = new PainlessPlugin();){
            painlessPlugin.loadExtensions(new ExtensiblePlugin.ExtensionLoader(){

                @Override
                public <T> List<T> loadExtensions(Class<T> extensionPointType) {
                    if (extensionPointType.isAssignableFrom(PainlessExtension.class)) {
                        ArrayList<PainlessExtension> extensions = new ArrayList<PainlessExtension>();
                        extensions.add(new ConstantKeywordPainlessExtension());
                        extensions.add(new ProcessorsWhitelistExtension());
                        extensions.add(new SpatialPainlessExtension());
                        extensions.add(new WildcardPainlessExtension());
                        return extensions;
                    }
                    return List.of();
                }
            });
            ScriptEngine scriptEngine = painlessPlugin.getScriptEngine(settings, Set.of(IngestScript.CONTEXT, IngestConditionalScript.CONTEXT));
            return scriptEngine;
        }
    }
}

