/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.json.jackson;

import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.jackson.JacksonJsonpLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.spi.JsonProvider;
import jakarta.json.stream.JsonParsingException;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

class JsonValueParser {
    private final JsonProvider provider = JsonpUtils.provider();

    JsonValueParser() {
    }

    public JsonObject parseObject(JsonParser parser) throws IOException {
        JsonToken token;
        JsonObjectBuilder ob = this.provider.createObjectBuilder();
        while ((token = parser.nextToken()) != JsonToken.END_OBJECT) {
            if (token != JsonToken.FIELD_NAME) {
                throw new JsonParsingException("Expected a property name", new JacksonJsonpLocation(parser));
            }
            String name = parser.getCurrentName();
            parser.nextToken();
            ob.add(name, this.parseValue(parser));
        }
        return ob.build();
    }

    public JsonArray parseArray(JsonParser parser) throws IOException {
        JsonArrayBuilder ab = this.provider.createArrayBuilder();
        while (parser.nextToken() != JsonToken.END_ARRAY) {
            ab.add(this.parseValue(parser));
        }
        return ab.build();
    }

    public JsonValue parseValue(JsonParser parser) throws IOException {
        JsonToken jsonToken = parser.currentToken();
        switch (parser.currentToken()) {
            case START_OBJECT: {
                return this.parseObject(parser);
            }
            case START_ARRAY: {
                return this.parseArray(parser);
            }
            case VALUE_TRUE: {
                return JsonValue.TRUE;
            }
            case VALUE_FALSE: {
                return JsonValue.FALSE;
            }
            case VALUE_NULL: {
                return JsonValue.NULL;
            }
            case VALUE_STRING: {
                return this.provider.createValue(parser.getText());
            }
            case VALUE_NUMBER_FLOAT: 
            case VALUE_NUMBER_INT: {
                switch (parser.getNumberType()) {
                    case INT: {
                        return this.provider.createValue(parser.getIntValue());
                    }
                    case LONG: {
                        return this.provider.createValue(parser.getLongValue());
                    }
                    case FLOAT: 
                    case DOUBLE: {
                        return new DoubleNumber(parser.getDoubleValue());
                    }
                    case BIG_DECIMAL: {
                        return this.provider.createValue(parser.getDecimalValue());
                    }
                    case BIG_INTEGER: {
                        return this.provider.createValue(parser.getBigIntegerValue());
                    }
                }
            }
        }
        throw new JsonParsingException("Unexpected token '" + parser.currentToken() + "'", new JacksonJsonpLocation(parser));
    }

    private static class DoubleNumber
    implements JsonNumber {
        private final double value;

        DoubleNumber(double value) {
            this.value = value;
        }

        @Override
        public boolean isIntegral() {
            return false;
        }

        @Override
        public int intValue() {
            return (int)this.value;
        }

        @Override
        public int intValueExact() {
            int result = (int)this.value;
            if ((double)result == this.value) {
                return result;
            }
            throw new ArithmeticException();
        }

        @Override
        public long longValue() {
            return (long)this.value;
        }

        @Override
        public long longValueExact() {
            long result = (long)this.value;
            if ((double)result == this.value) {
                return result;
            }
            throw new ArithmeticException();
        }

        @Override
        public BigInteger bigIntegerValue() {
            return this.bigDecimalValue().toBigInteger();
        }

        @Override
        public BigInteger bigIntegerValueExact() {
            return this.bigDecimalValue().toBigIntegerExact();
        }

        @Override
        public double doubleValue() {
            return this.value;
        }

        @Override
        public BigDecimal bigDecimalValue() {
            return new BigDecimal(this.value);
        }

        @Override
        public JsonValue.ValueType getValueType() {
            return JsonValue.ValueType.NUMBER;
        }

        @Override
        public Number numberValue() {
            return this.value;
        }

        @Override
        public String toString() {
            return String.valueOf(this.value);
        }

        @Override
        public int hashCode() {
            return Double.hashCode(this.value);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof DoubleNumber && ((DoubleNumber)obj).value == this.value;
        }
    }
}

