/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.elasticsearch.snapshot.RepositorySettingsBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SharedFileSystemRepositorySettings
extends RepositorySettingsBase {
    private final String location;
    @Nullable
    private final Integer maxNumberOfSnapshots;
    @Nullable
    private final Boolean readonly;
    public static final JsonpDeserializer<SharedFileSystemRepositorySettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SharedFileSystemRepositorySettings::setupSharedFileSystemRepositorySettingsDeserializer);

    private SharedFileSystemRepositorySettings(Builder builder) {
        super(builder);
        this.location = ApiTypeHelper.requireNonNull(builder.location, this, "location");
        this.maxNumberOfSnapshots = builder.maxNumberOfSnapshots;
        this.readonly = builder.readonly;
    }

    public static SharedFileSystemRepositorySettings of(Function<Builder, ObjectBuilder<SharedFileSystemRepositorySettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String location() {
        return this.location;
    }

    @Nullable
    public final Integer maxNumberOfSnapshots() {
        return this.maxNumberOfSnapshots;
    }

    @Nullable
    public final Boolean readonly() {
        return this.readonly;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("location");
        generator.write(this.location);
        if (this.maxNumberOfSnapshots != null) {
            generator.writeKey("max_number_of_snapshots");
            generator.write(this.maxNumberOfSnapshots);
        }
        if (this.readonly != null) {
            generator.writeKey("readonly");
            generator.write(this.readonly);
        }
    }

    protected static void setupSharedFileSystemRepositorySettingsDeserializer(ObjectDeserializer<Builder> op) {
        RepositorySettingsBase.setupRepositorySettingsBaseDeserializer(op);
        op.add(Builder::location, JsonpDeserializer.stringDeserializer(), "location");
        op.add(Builder::maxNumberOfSnapshots, JsonpDeserializer.integerDeserializer(), "max_number_of_snapshots");
        op.add(Builder::readonly, JsonpDeserializer.booleanDeserializer(), "readonly");
    }

    public static class Builder
    extends RepositorySettingsBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SharedFileSystemRepositorySettings> {
        private String location;
        @Nullable
        private Integer maxNumberOfSnapshots;
        @Nullable
        private Boolean readonly;

        public final Builder location(String value) {
            this.location = value;
            return this;
        }

        public final Builder maxNumberOfSnapshots(@Nullable Integer value) {
            this.maxNumberOfSnapshots = value;
            return this;
        }

        public final Builder readonly(@Nullable Boolean value) {
            this.readonly = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SharedFileSystemRepositorySettings build() {
            this._checkSingleUse();
            return new SharedFileSystemRepositorySettings(this);
        }
    }
}

