/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.BulkDeleteRoleResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class BulkDeleteRoleRequest
extends RequestBase
implements JsonpSerializable {
    private final List<String> names;
    @Nullable
    private final Refresh refresh;
    public static final JsonpDeserializer<BulkDeleteRoleRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, BulkDeleteRoleRequest::setupBulkDeleteRoleRequestDeserializer);
    public static final Endpoint<BulkDeleteRoleRequest, BulkDeleteRoleResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<BulkDeleteRoleRequest, BulkDeleteRoleResponse>("es/security.bulk_delete_role", request -> "DELETE", request -> "/_security/role", request -> Collections.emptyMap(), request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.refresh != null) {
            params.put("refresh", request.refresh.jsonValue());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, BulkDeleteRoleResponse._DESERIALIZER);

    private BulkDeleteRoleRequest(Builder builder) {
        this.names = ApiTypeHelper.unmodifiableRequired(builder.names, (Object)this, "names");
        this.refresh = builder.refresh;
    }

    public static BulkDeleteRoleRequest of(Function<Builder, ObjectBuilder<BulkDeleteRoleRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> names() {
        return this.names;
    }

    @Nullable
    public final Refresh refresh() {
        return this.refresh;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.names)) {
            generator.writeKey("names");
            generator.writeStartArray();
            for (String item0 : this.names) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    protected static void setupBulkDeleteRoleRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::names, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "names");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<BulkDeleteRoleRequest> {
        private List<String> names;
        @Nullable
        private Refresh refresh;

        public final Builder names(List<String> list) {
            this.names = Builder._listAddAll(this.names, list);
            return this;
        }

        public final Builder names(String value, String ... values) {
            this.names = Builder._listAdd(this.names, value, values);
            return this;
        }

        public final Builder refresh(@Nullable Refresh value) {
            this.refresh = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public BulkDeleteRoleRequest build() {
            this._checkSingleUse();
            return new BulkDeleteRoleRequest(this);
        }
    }
}

