/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinition;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinitionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class HunspellTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    @Nullable
    private final Boolean dedup;
    @Nullable
    private final String dictionary;
    private final String locale;
    @Nullable
    private final Boolean longestOnly;
    public static final JsonpDeserializer<HunspellTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HunspellTokenFilter::setupHunspellTokenFilterDeserializer);

    private HunspellTokenFilter(Builder builder) {
        super(builder);
        this.dedup = builder.dedup;
        this.dictionary = builder.dictionary;
        this.locale = ApiTypeHelper.requireNonNull(builder.locale, this, "locale");
        this.longestOnly = builder.longestOnly;
    }

    public static HunspellTokenFilter of(Function<Builder, ObjectBuilder<HunspellTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.Hunspell;
    }

    @Nullable
    public final Boolean dedup() {
        return this.dedup;
    }

    @Nullable
    public final String dictionary() {
        return this.dictionary;
    }

    public final String locale() {
        return this.locale;
    }

    @Nullable
    public final Boolean longestOnly() {
        return this.longestOnly;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "hunspell");
        super.serializeInternal(generator, mapper);
        if (this.dedup != null) {
            generator.writeKey("dedup");
            generator.write(this.dedup);
        }
        if (this.dictionary != null) {
            generator.writeKey("dictionary");
            generator.write(this.dictionary);
        }
        generator.writeKey("locale");
        generator.write(this.locale);
        if (this.longestOnly != null) {
            generator.writeKey("longest_only");
            generator.write(this.longestOnly);
        }
    }

    protected static void setupHunspellTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::dedup, JsonpDeserializer.booleanDeserializer(), "dedup");
        op.add(Builder::dictionary, JsonpDeserializer.stringDeserializer(), "dictionary");
        op.add(Builder::locale, JsonpDeserializer.stringDeserializer(), "locale", "lang", "language");
        op.add(Builder::longestOnly, JsonpDeserializer.booleanDeserializer(), "longest_only");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<HunspellTokenFilter> {
        @Nullable
        private Boolean dedup;
        @Nullable
        private String dictionary;
        private String locale;
        @Nullable
        private Boolean longestOnly;

        public final Builder dedup(@Nullable Boolean value) {
            this.dedup = value;
            return this;
        }

        public final Builder dictionary(@Nullable String value) {
            this.dictionary = value;
            return this;
        }

        public final Builder locale(String value) {
            this.locale = value;
            return this;
        }

        public final Builder longestOnly(@Nullable Boolean value) {
            this.longestOnly = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public HunspellTokenFilter build() {
            this._checkSingleUse();
            return new HunspellTokenFilter(this);
        }
    }
}

