/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.objectweb.asm.commons;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.jruby.org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Method {
    private final String name;
    private final String descriptor;
    private static final Map<String, String> PRIMITIVE_TYPE_DESCRIPTORS;

    public Method(String name2, String descriptor) {
        this.name = name2;
        this.descriptor = descriptor;
    }

    public Method(String name2, Type returnType, Type[] argumentTypes) {
        this(name2, Type.getMethodDescriptor(returnType, argumentTypes));
    }

    public static Method getMethod(java.lang.reflect.Method method2) {
        return new Method(method2.getName(), Type.getMethodDescriptor(method2));
    }

    public static Method getMethod(Constructor<?> constructor2) {
        return new Method("<init>", Type.getConstructorDescriptor(constructor2));
    }

    public static Method getMethod(String method2) {
        return Method.getMethod(method2, false);
    }

    public static Method getMethod(String method2, boolean defaultPackage) {
        int currentArgumentEndIndex;
        int spaceIndex = method2.indexOf(32);
        int currentArgumentStartIndex = method2.indexOf(40, spaceIndex) + 1;
        int endIndex = method2.indexOf(41, currentArgumentStartIndex);
        if (spaceIndex == -1 || currentArgumentStartIndex == 0 || endIndex == -1) {
            throw new IllegalArgumentException();
        }
        String returnType = method2.substring(0, spaceIndex);
        String methodName = method2.substring(spaceIndex + 1, currentArgumentStartIndex - 1).trim();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        do {
            String argumentDescriptor;
            if ((currentArgumentEndIndex = method2.indexOf(44, currentArgumentStartIndex)) == -1) {
                argumentDescriptor = Method.getDescriptorInternal(method2.substring(currentArgumentStartIndex, endIndex).trim(), defaultPackage);
            } else {
                argumentDescriptor = Method.getDescriptorInternal(method2.substring(currentArgumentStartIndex, currentArgumentEndIndex).trim(), defaultPackage);
                currentArgumentStartIndex = currentArgumentEndIndex + 1;
            }
            stringBuilder.append(argumentDescriptor);
        } while (currentArgumentEndIndex != -1);
        stringBuilder.append(')').append(Method.getDescriptorInternal(returnType, defaultPackage));
        return new Method(methodName, stringBuilder.toString());
    }

    private static String getDescriptorInternal(String type2, boolean defaultPackage) {
        if ("".equals(type2)) {
            return type2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int arrayBracketsIndex = 0;
        while ((arrayBracketsIndex = type2.indexOf("[]", arrayBracketsIndex) + 1) > 0) {
            stringBuilder.append('[');
        }
        String elementType = type2.substring(0, type2.length() - stringBuilder.length() * 2);
        String descriptor = PRIMITIVE_TYPE_DESCRIPTORS.get(elementType);
        if (descriptor != null) {
            stringBuilder.append(descriptor);
        } else {
            stringBuilder.append('L');
            if (elementType.indexOf(46) < 0) {
                if (!defaultPackage) {
                    stringBuilder.append("java/lang/");
                }
                stringBuilder.append(elementType);
            } else {
                stringBuilder.append(elementType.replace('.', '/'));
            }
            stringBuilder.append(';');
        }
        return stringBuilder.toString();
    }

    public String getName() {
        return this.name;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public Type getReturnType() {
        return Type.getReturnType(this.descriptor);
    }

    public Type[] getArgumentTypes() {
        return Type.getArgumentTypes(this.descriptor);
    }

    public String toString() {
        return Method.stringConcat$0(this.name, this.descriptor);
    }

    private static /* synthetic */ String stringConcat$0(String string2, String string3) {
        return string2 + string3;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Method)) {
            return false;
        }
        Method otherMethod = (Method)other;
        return this.name.equals(otherMethod.name) && this.descriptor.equals(otherMethod.descriptor);
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.descriptor.hashCode();
    }

    static {
        HashMap<String, String> descriptors = new HashMap<String, String>();
        descriptors.put("void", "V");
        descriptors.put("byte", "B");
        descriptors.put("char", "C");
        descriptors.put("double", "D");
        descriptors.put("float", "F");
        descriptors.put("int", "I");
        descriptors.put("long", "J");
        descriptors.put("short", "S");
        descriptors.put("boolean", "Z");
        PRIMITIVE_TYPE_DESCRIPTORS = descriptors;
    }
}

