"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostIsolationExceptionsContainer = void 0;
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../../common/constants");
var _links = require("../../../common/links");
var _constants2 = require("../../common/constants");
var _ = require("../../../app/404");
var _host_isolation_exceptions_list = require("./view/host_isolation_exceptions_list");
var _no_privileges = require("../../../common/components/no_privileges");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Provides the routing container for the hosts related views
 */
const HostIsolationExceptionsContainer = exports.HostIsolationExceptionsContainer = /*#__PURE__*/(0, _react.memo)(() => {
  const canAccessHostIsolationExceptionsLink = (0, _links.useLinkAuthorized)(_constants.SecurityPageName.hostIsolationExceptions);
  if (!canAccessHostIsolationExceptionsLink) {
    // TODO: Render a license/productType upsell page
    return /*#__PURE__*/_react.default.createElement(_no_privileges.NoPrivilegesPage, {
      docLinkSelector: ({
        securitySolution
      }) => securitySolution.privileges
    });
  }
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants2.MANAGEMENT_ROUTING_HOST_ISOLATION_EXCEPTIONS_PATH,
    exact: true,
    component: _host_isolation_exceptions_list.HostIsolationExceptionsList
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "*",
    component: _.NotFoundPage
  }));
});
HostIsolationExceptionsContainer.displayName = 'HostIsolationExceptionsContainer';