"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HistoryItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _common = require("@kbn/kibana-react-plugin/common");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
var _use_data_test_subj = require("../hooks/state_selectors/use_data_test_subj");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const verticalSpacing = (0, _common.css)`
  ${({
  theme: {
    eui
  }
}) => eui.euiSizeL}
`;
const StyledEuiFlexItemHistoryItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  border-bottom: ${({
  theme: {
    eui
  }
}) => eui.euiBorderWidthThin} dashed
    ${({
  theme: {
    eui
  }
}) => eui.euiBorderColor};
  margin-bottom: ${verticalSpacing};
  padding-bottom: ${verticalSpacing};
`;
const HistoryItem = exports.HistoryItem = /*#__PURE__*/(0, _react.memo)(({
  children
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)((0, _use_data_test_subj.useDataTestSubj)());
  return /*#__PURE__*/_react.default.createElement(StyledEuiFlexItemHistoryItem, {
    grow: true,
    "data-test-subj": getTestId('historyItem')
  }, children);
});
HistoryItem.displayName = 'HistoryItem';