"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isCommonError = exports.GenericEntityPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _analytics = require("@kbn/analytics");
var _ui_metrics = require("@kbn/cloud-security-posture-common/utils/ui_metrics");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _types = require("../../../../common/entity_analytics/types");
var _left_panel_header = require("../shared/components/left_panel/left_panel_header");
var _use_open_generic_entity_details_left_panel = require("./hooks/use_open_generic_entity_details_left_panel");
var _use_get_generic_entity = require("./hooks/use_get_generic_entity");
var _flyout_navigation = require("../../shared/components/flyout_navigation");
var _use_generic_entity_criticality = require("./hooks/use_generic_entity_criticality");
var _header = require("./header");
var _content = require("./content");
var _footer = require("./footer");
var _kibana = require("../../../common/lib/kibana");
var _constants = require("../../../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isCommonError = error => {
  var _error$body, _error$body2, _error$body3;
  // @ts-ignore TS2339: Property body does not exist on type {}
  if (!(error !== null && error !== void 0 && error.body) || !(error !== null && error !== void 0 && (_error$body = error.body) !== null && _error$body !== void 0 && _error$body.error) || !(error !== null && error !== void 0 && (_error$body2 = error.body) !== null && _error$body2 !== void 0 && _error$body2.message) || !(error !== null && error !== void 0 && (_error$body3 = error.body) !== null && _error$body3 !== void 0 && _error$body3.statusCode)) {
    return false;
  }
  return true;
};
exports.isCommonError = isCommonError;
const GenericEntityPanel = ({
  entityDocId,
  scopeId
}) => {
  var _getGenericEntity$dat, _getGenericEntity$dat2, _getGenericEntity$dat3, _getGenericEntity$dat4, _getGenericEntity$dat5, _getGenericEntity$dat6, _getGenericEntity$dat8, _getGenericEntity$dat9;
  const {
    uiSettings
  } = (0, _kibana.useKibana)().services;
  const assetInventoryEnabled = uiSettings.get(_constants.ENABLE_ASSET_INVENTORY_SETTING, true);
  const {
    getGenericEntity
  } = (0, _use_get_generic_entity.useGetGenericEntity)(entityDocId);
  const {
    getAssetCriticality
  } = (0, _use_generic_entity_criticality.useGenericEntityCriticality)({
    enabled: !!((_getGenericEntity$dat = getGenericEntity.data) !== null && _getGenericEntity$dat !== void 0 && (_getGenericEntity$dat2 = _getGenericEntity$dat._source) !== null && _getGenericEntity$dat2 !== void 0 && _getGenericEntity$dat2.entity.id),
    idField: _types.EntityIdentifierFields.generic,
    // @ts-ignore since this query is only enabled when the entity.id exists, we can safely assume that idValue won't be undefined
    idValue: (_getGenericEntity$dat3 = getGenericEntity.data) === null || _getGenericEntity$dat3 === void 0 ? void 0 : (_getGenericEntity$dat4 = _getGenericEntity$dat3._source) === null || _getGenericEntity$dat4 === void 0 ? void 0 : _getGenericEntity$dat4.entity.id
  });
  const {
    openGenericEntityDetails
  } = (0, _use_open_generic_entity_details_left_panel.useOpenGenericEntityDetailsLeftPanel)({
    insightsField: 'related.entity',
    insightsValue: ((_getGenericEntity$dat5 = getGenericEntity.data) === null || _getGenericEntity$dat5 === void 0 ? void 0 : (_getGenericEntity$dat6 = _getGenericEntity$dat5._source) === null || _getGenericEntity$dat6 === void 0 ? void 0 : _getGenericEntity$dat6.entity.id) || '',
    entityDocId,
    scopeId
  });
  const openGenericEntityDetailsPanelByPath = path => {
    return openGenericEntityDetails(path);
  };
  (0, _react.useEffect)(() => {
    var _getGenericEntity$dat7;
    if ((_getGenericEntity$dat7 = getGenericEntity.data) !== null && _getGenericEntity$dat7 !== void 0 && _getGenericEntity$dat7._id) {
      _ui_metrics.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.COUNT, _ui_metrics.GENERIC_ENTITY_FLYOUT_OPENED);
    }
  }, [(_getGenericEntity$dat8 = getGenericEntity.data) === null || _getGenericEntity$dat8 === void 0 ? void 0 : _getGenericEntity$dat8._id]);
  if (getGenericEntity.isLoading || getAssetCriticality.isLoading) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xxl",
      css: {
        position: 'absolute',
        inset: '50%'
      }
    }));
  }
  if (!((_getGenericEntity$dat9 = getGenericEntity.data) !== null && _getGenericEntity$dat9 !== void 0 && _getGenericEntity$dat9._source) || getGenericEntity.isError) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      color: "danger",
      iconType: "warning",
      title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.genericEntityFlyout.errorTitle",
        defaultMessage: "Unable to load entity"
      })),
      body: isCommonError(getGenericEntity.error) ? /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.genericEntityFlyout.errorBody",
        defaultMessage: "{error} {statusCode}: {body}",
        values: {
          error: getGenericEntity.error.body.error,
          statusCode: getGenericEntity.error.body.statusCode,
          body: getGenericEntity.error.body.message
        }
      })) : undefined
    }));
  }
  const source = getGenericEntity.data._source;
  const entity = getGenericEntity.data._source.entity;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_flyout_navigation.FlyoutNavigation, {
    flyoutIsExpandable: true,
    expandDetails: () => openGenericEntityDetailsPanelByPath({
      tab: _left_panel_header.EntityDetailsLeftPanelTab.FIELDS_TABLE
    })
  }), /*#__PURE__*/_react.default.createElement(_header.GenericEntityFlyoutHeader, {
    entity: entity,
    source: source
  }), /*#__PURE__*/_react.default.createElement(_content.GenericEntityFlyoutContent, {
    source: source,
    openGenericEntityDetailsPanelByPath: openGenericEntityDetailsPanelByPath,
    insightsField: 'related.entity',
    insightsValue: source.entity.id
  }), assetInventoryEnabled && /*#__PURE__*/_react.default.createElement(_footer.GenericEntityFlyoutFooter, {
    entityId: entity.id
  }));
};
exports.GenericEntityPanel = GenericEntityPanel;
GenericEntityPanel.displayName = 'GenericEntityPanel';