"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GenericEntityFlyoutFooter = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _take_action = require("../shared/components/take_action");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GenericEntityFlyoutFooter = ({
  entityId
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_take_action.TakeAction, {
    isDisabled: !entityId,
    kqlQuery: `entity.id: "${entityId}" OR related.entity: "${entityId}"`
  })))));
};
exports.GenericEntityFlyoutFooter = GenericEntityFlyoutFooter;