"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResponsiveDataCards = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * A component that displays a group of data cards in a responsive layout.
 * Depending on the width of the container, the cards will be displayed in a row layout or a two columns layout.
 */
const ResponsiveDataCards = ({
  cards,
  collapseWidth = 750
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _react2.css)`
        container-type: inline-size;
      `,
    gutterSize: "s",
    responsive: false,
    wrap: true
  }, cards.map((card, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: index,
    css: (0, _react2.css)`
            flex-basis: calc(25% - ${euiTheme.size.s});
            width: calc(25% - ${euiTheme.size.s});

            @container (max-width: ${collapseWidth}px) {
              flex: calc(50% - ${euiTheme.size.s});
              width: calc(50% - ${euiTheme.size.s});
            }
          `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    "data-test-subj": "responsive-data-card",
    title: card.title,
    description: card.description,
    textAlign: "left",
    titleSize: "xs",
    hasBorder: true
  }))));
};
exports.ResponsiveDataCards = ResponsiveDataCards;