"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useWhichFlyout = void 0;
var _flyouts = require("../constants/flyouts");
var _use_url_state = require("../../../../common/hooks/use_url_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook that returns which flyout is the user currently interacting with.
 * If the url contains timelineFlyout parameter and its value is not empty, we know the timeline flyout is rendered.
 * As it is always on top of the normal flyout, we can deduce which flyout the user is interacting with.
 */
const useWhichFlyout = () => {
  const query = new URLSearchParams(window.location.search);
  const queryHasSecuritySolutionFlyout = query.has(_use_url_state.URL_PARAM_KEY.flyout);
  const securitySolutionFlyoutHasValue = query.get(_use_url_state.URL_PARAM_KEY.flyout) !== '()' && query.get(_use_url_state.URL_PARAM_KEY.flyout) !== '(preview:!())';
  const isSecuritySolutionFlyoutOpen = queryHasSecuritySolutionFlyout && securitySolutionFlyoutHasValue;
  const queryHasTimelineFlyout = query.has(_use_url_state.URL_PARAM_KEY.timelineFlyout);
  const timelineFlyoutHasValue = query.get(_use_url_state.URL_PARAM_KEY.timelineFlyout) !== '()' && query.get(_use_url_state.URL_PARAM_KEY.timelineFlyout) !== '(preview:!())';
  const isTimelineFlyoutOpen = queryHasTimelineFlyout && timelineFlyoutHasValue;
  if (isSecuritySolutionFlyoutOpen && isTimelineFlyoutOpen) {
    return _flyouts.Flyouts.timeline;
  }
  if (isSecuritySolutionFlyoutOpen) {
    return _flyouts.Flyouts.securitySolution;
  }
  if (isTimelineFlyoutOpen) {
    return _flyouts.Flyouts.timeline;
  }
  return null;
};
exports.useWhichFlyout = useWhichFlyout;