"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBasicDataFromDetailsData = void 0;
var _fp = require("lodash/fp");
var _react = require("react");
var _get_event_details_field_values = require("../../../../common/lib/endpoint/utils/get_event_details_field_values");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useBasicDataFromDetailsData = data => {
  const agentId = (0, _react.useMemo)(() => (0, _get_event_details_field_values.getAlertDetailsFieldValue)({
    category: 'agent',
    field: 'agent.id'
  }, data), [data]);
  const alertId = (0, _react.useMemo)(() => (0, _get_event_details_field_values.getAlertDetailsFieldValue)({
    category: '_id',
    field: '_id'
  }, data), [data]);
  const alertUrl = (0, _react.useMemo)(() => (0, _get_event_details_field_values.getAlertDetailsFieldValue)({
    category: 'kibana',
    field: 'kibana.alert.url'
  }, data), [data]);
  const hostName = (0, _react.useMemo)(() => (0, _get_event_details_field_values.getAlertDetailsFieldValue)({
    category: 'host',
    field: 'host.name'
  }, data), [data]);
  const indexName = (0, _react.useMemo)(() => (0, _get_event_details_field_values.getAlertDetailsFieldValue)({
    category: '_index',
    field: '_index'
  }, data), [data]);
  const isAlert = (0, _fp.some)({
    category: 'kibana',
    field: 'kibana.alert.rule.uuid'
  }, data);
  const ruleDescription = (0, _react.useMemo)(() => (0, _get_event_details_field_values.getAlertDetailsFieldValue)({
    category: 'kibana',
    field: 'kibana.alert.rule.description'
  }, data), [data]);
  const ruleId = (0, _react.useMemo)(() => isAlert ? (0, _get_event_details_field_values.getAlertDetailsFieldValue)({
    category: 'kibana',
    field: 'kibana.alert.rule.uuid'
  }, data) : (0, _get_event_details_field_values.getAlertDetailsFieldValue)({
    category: 'signal',
    field: 'signal.rule.id'
  }, data), [isAlert, data]);
  const ruleName = (0, _react.useMemo)(() => (0, _get_event_details_field_values.getAlertDetailsFieldValue)({
    category: 'kibana',
    field: 'kibana.alert.rule.name'
  }, data), [data]);
  const ruleRuleId = (0, _react.useMemo)(() => (0, _get_event_details_field_values.getAlertDetailsFieldValue)({
    category: 'signal',
    field: 'signal.rule.rule_id'
  }, data), [data]);
  const timestamp = (0, _react.useMemo)(() => (0, _get_event_details_field_values.getAlertDetailsFieldValue)({
    category: 'base',
    field: '@timestamp'
  }, data), [data]);
  const userName = (0, _react.useMemo)(() => (0, _get_event_details_field_values.getAlertDetailsFieldValue)({
    category: 'user',
    field: 'user.name'
  }, data), [data]);
  return (0, _react.useMemo)(() => ({
    agentId,
    alertId,
    alertUrl,
    data,
    hostName,
    indexName,
    isAlert,
    ruleDescription,
    ruleId,
    ruleName,
    ruleRuleId,
    timestamp,
    userName
  }), [agentId, alertId, alertUrl, data, hostName, indexName, isAlert, ruleDescription, ruleId, ruleName, ruleRuleId, timestamp, userName]);
};
exports.useBasicDataFromDetailsData = useBasicDataFromDetailsData;