"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GraphVisualization = exports.GRAPH_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _use_data_view = require("../../../../data_view_manager/hooks/use_data_view");
var _use_get_sourcerer_data_view = require("../../../../sourcerer/components/use_get_sourcerer_data_view");
var _model = require("../../../../sourcerer/store/model");
var _context = require("../../shared/context");
var _test_ids = require("./test_ids");
var _use_graph_preview = require("../../shared/hooks/use_graph_preview");
var _use_investigate_in_timeline = require("../../../../common/hooks/timeline/use_investigate_in_timeline");
var _normalize_time_range = require("../../../../common/utils/normalize_time_range");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const GraphInvestigationLazy = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/cloud-security-posture-graph'))).then(module => ({
  default: module.GraphInvestigation
})));
const GRAPH_ID = exports.GRAPH_ID = 'graph-visualization';

/**
 * Graph visualization view displayed in the document details expandable flyout left section under the Visualize tab
 */
const GraphVisualization = exports.GraphVisualization = /*#__PURE__*/(0, _react.memo)(() => {
  const oldDataView = (0, _use_get_sourcerer_data_view.useGetScopedSourcererDataView)({
    sourcererScope: _model.SourcererScopeName.default
  });
  const {
    dataView: experimentalDataView
  } = (0, _use_data_view.useDataView)(_model.SourcererScopeName.default);
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const dataView = newDataViewPickerEnabled ? experimentalDataView : oldDataView;
  const {
    getFieldsData,
    dataAsNestedObject,
    dataFormattedForFieldBrowser
  } = (0, _context.useDocumentDetailsContext)();
  const {
    eventIds,
    timestamp = new Date().toISOString(),
    isAlert
  } = (0, _use_graph_preview.useGraphPreview)({
    getFieldsData,
    ecsData: dataAsNestedObject,
    dataFormattedForFieldBrowser
  });
  const originEventIds = eventIds.map(id => ({
    id,
    isAlert
  }));
  const {
    investigateInTimeline
  } = (0, _use_investigate_in_timeline.useInvestigateInTimeline)();
  const openTimelineCallback = (0, _react.useCallback)((query, filters, timeRange) => {
    const from = _datemath.default.parse(timeRange.from);
    const to = _datemath.default.parse(timeRange.to);
    if (!from || !to) {
      // TODO: show error message
      return;
    }
    const normalizedTimeRange = (0, _normalize_time_range.normalizeTimeRange)({
      ...timeRange,
      from: from.toISOString(),
      to: to.toISOString()
    });
    investigateInTimeline({
      keepDataView: true,
      query,
      filters,
      timeRange: {
        from: normalizedTimeRange.from,
        to: normalizedTimeRange.to,
        kind: 'absolute'
      }
    });
  }, [investigateInTimeline]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": _test_ids.GRAPH_VISUALIZATION_TEST_ID,
    css: (0, _react2.css)`
        height: calc(100vh - 250px);
        min-height: 400px;
        width: 100%;
      `
  }, dataView && /*#__PURE__*/_react.default.createElement(_react.default.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)
  }, /*#__PURE__*/_react.default.createElement(GraphInvestigationLazy, {
    initialState: {
      dataView,
      originEventIds,
      timeRange: {
        from: `${timestamp}||-30m`,
        to: `${timestamp}||+30m`
      }
    },
    showInvestigateInTimeline: true,
    showToggleSearch: true,
    onInvestigateInTimeline: openTimelineCallback
  })));
});
GraphVisualization.displayName = 'GraphVisualization';