"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FindingsVulnerabilityPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _formatted_date = require("../../../../common/components/formatted_date");
var _flyout_navigation = require("../../../shared/components/flyout_navigation");
var _kibana = require("../../../../common/lib/kibana");
var _flyout_header = require("../../../shared/components/flyout_header");
var _flyout_body = require("../../../shared/components/flyout_body");
var _flyout_title = require("../../../shared/components/flyout_title");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FindingsVulnerabilityPanel = ({
  vulnerabilityId,
  resourceId,
  packageName,
  packageVersion,
  eventId,
  isPreviewMode
}) => {
  const {
    cloudSecurityPosture
  } = (0, _kibana.useKibana)().services;
  const CspVulnerabilityFlyout = cloudSecurityPosture.getCloudSecurityPostureVulnerabilityFlyout();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_flyout_navigation.FlyoutNavigation, {
    flyoutIsExpandable: false,
    isPreviewMode: isPreviewMode
  }), /*#__PURE__*/_react.default.createElement(CspVulnerabilityFlyout.Component, {
    vulnerabilityId: vulnerabilityId,
    resourceId: resourceId,
    packageName: packageName,
    packageVersion: packageVersion,
    eventId: eventId
  }, ({
    finding,
    createRuleFn
  }) => {
    var _finding$vulnerabilit, _finding$vulnerabilit2, _finding$vulnerabilit3, _finding$vulnerabilit4, _finding$vulnerabilit5;
    const vulnerabilityTitle = (_finding$vulnerabilit = finding === null || finding === void 0 ? void 0 : (_finding$vulnerabilit2 = finding.vulnerability) === null || _finding$vulnerabilit2 === void 0 ? void 0 : _finding$vulnerabilit2.title) !== null && _finding$vulnerabilit !== void 0 ? _finding$vulnerabilit : _i18n.i18n.translate('xpack.securitySolution.csp.vulnerabilitiesFlyout.emptyTitleHolder', {
      defaultMessage: 'No title available'
    });
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_flyout_header.FlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      responsive: false,
      direction: "column"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_cloudSecurityPosture.SeverityStatusBadge, {
      severity: (0, _cloudSecurityPosture.getNormalizedSeverity)(finding === null || finding === void 0 ? void 0 : (_finding$vulnerabilit3 = finding.vulnerability) === null || _finding$vulnerabilit3 === void 0 ? void 0 : _finding$vulnerabilit3.severity)
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    })), (finding === null || finding === void 0 ? void 0 : (_finding$vulnerabilit4 = finding.vulnerability) === null || _finding$vulnerabilit4 === void 0 ? void 0 : _finding$vulnerabilit4.published_date) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("b", null, _i18n.i18n.translate('xpack.securitySolution.csp.vulnerabilitiesFlyout.published', {
      defaultMessage: 'Published '
    })), (0, _moment.default)(finding === null || finding === void 0 ? void 0 : (_finding$vulnerabilit5 = finding.vulnerability) === null || _finding$vulnerabilit5 === void 0 ? void 0 : _finding$vulnerabilit5.published_date).format('LL').toString(), ' | ', /*#__PURE__*/_react.default.createElement("b", null, _i18n.i18n.translate('xpack.securitySolution.csp.vulnerabilitiesFlyout.firstFound', {
      defaultMessage: 'First found '
    })), /*#__PURE__*/_react.default.createElement(_formatted_date.PreferenceFormattedDate, {
      value: new Date(finding['@timestamp'])
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    })))), /*#__PURE__*/_react.default.createElement(_flyout_title.FlyoutTitle, {
      title: vulnerabilityTitle
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement(CspVulnerabilityFlyout.Header, {
      finding: finding
    })), /*#__PURE__*/_react.default.createElement(_flyout_body.FlyoutBody, null, /*#__PURE__*/_react.default.createElement(CspVulnerabilityFlyout.Body, {
      finding: finding
    })), !isPreviewMode && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(CspVulnerabilityFlyout.Footer, {
      createRuleFn: createRuleFn
    })));
  }));
};
exports.FindingsVulnerabilityPanel = FindingsVulnerabilityPanel;
FindingsVulnerabilityPanel.displayName = 'FindingsVulnerabilityPanel';