"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AttackDiscoveryPanel = exports.ATTACK_DISCOVERY_VIEW_DETAILS_BUTTON_TEST_ID = void 0;
var _reactRouterDom = require("react-router-dom");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _i18n = require("@kbn/i18n");
var _attack_discovery_details = require("./attack_discovery_details");
var _use_ids_from_url = require("../../../attack_discovery/pages/results/history/use_ids_from_url");
var _use_attack_discovery_history_timerange = require("../../../attack_discovery/pages/use_attack_discovery_history_timerange");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ATTACK_DISCOVERY_VIEW_DETAILS_BUTTON_TEST_ID = exports.ATTACK_DISCOVERY_VIEW_DETAILS_BUTTON_TEST_ID = 'ai-for-soc-alert-flyout-attack-discovery-view-details-button';
const ALERT_PART = _i18n.i18n.translate('xpack.securitySolution.alertSummary.attackDiscovery.alertPart', {
  defaultMessage: 'This alert is part of a'
});
const VIEW_DETAILS = _i18n.i18n.translate('xpack.securitySolution.alertSummary.attackDiscovery.viewDetails', {
  defaultMessage: 'View details in Attack Discovery'
});
/**
 * Component rendered in the attack discovery section of the AI for SOC alert flyout.
 * It wraps all the details for the attack discovery for the visualized alert.
 */
const AttackDiscoveryPanel = exports.AttackDiscoveryPanel = /*#__PURE__*/(0, _react.memo)(({
  attackDiscovery,
  end,
  start
}) => {
  const {
    navigateTo
  } = (0, _securitySolutionNavigation.useNavigateTo)();
  const {
    pathname
  } = (0, _reactRouterDom.useLocation)();
  const {
    setIdsUrl
  } = (0, _use_ids_from_url.useIdsFromUrl)();
  const {
    setHistoryEnd,
    setHistoryStart
  } = (0, _use_attack_discovery_history_timerange.useAttackDiscoveryHistoryTimerange)();
  const handleNavigateToAttackDiscovery = (0, _react.useCallback)(() => {
    setHistoryStart(start);
    setHistoryEnd(end);
    if (pathname.includes('attack_discovery')) {
      setIdsUrl([attackDiscovery.id]);
    } else {
      navigateTo({
        path: `attack_discovery?id=${attackDiscovery.id}`
      });
    }
  }, [attackDiscovery.id, setHistoryStart, start, setHistoryEnd, end, pathname, setIdsUrl, navigateTo]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, ALERT_PART)), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, attackDiscovery.title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_attack_discovery_details.AttackDiscoveryDetails, {
    attackDiscovery: attackDiscovery
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconSide: "right",
    iconType: "popout",
    "data-test-subj": ATTACK_DISCOVERY_VIEW_DETAILS_BUTTON_TEST_ID,
    onClick: handleNavigateToAttackDiscovery,
    css: (0, _react2.css)`
              padding: 0;
            `
  }, VIEW_DETAILS)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }));
});
AttackDiscoveryPanel.displayName = 'AttackDiscoveryPanel';