"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.entityAnalyticsLinks = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../../common/constants");
var _translations = require("../app/translations");
var _privileged_user_monitoring_page = _interopRequireDefault(require("../common/images/privileged_user_monitoring_page.png"));
var _ea_overview_page = _interopRequireDefault(require("../common/images/ea_overview_page.png"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const privMonLinks = {
  isBeta: true,
  betaOptions: {
    text: _i18n.i18n.translate('xpack.securitySolution.navigation.privilegedUserMonitoring.betaStatus', {
      defaultMessage: 'TECHNICAL PREVIEW'
    })
  },
  id: _constants.SecurityPageName.entityAnalyticsPrivilegedUserMonitoring,
  title: _translations.ENTITY_ANALYTICS_PRIVILEGED_USER_MONITORING,
  description: _i18n.i18n.translate('xpack.securitySolution.navigation.privilegedUserMonitoring.description', {
    defaultMessage: 'Provides visibility into privileged user activity, helping security teams analyze account usage, track access events, and spot potential risks.'
  }),
  landingImage: _privileged_user_monitoring_page.default,
  path: _constants.ENTITY_ANALYTICS_PRIVILEGED_USER_MONITORING_PATH,
  globalSearchKeywords: [_i18n.i18n.translate('xpack.securitySolution.appLinks.privilegedUserMonitoring', {
    defaultMessage: 'Privileged user monitoring'
  })],
  hideWhenExperimentalKey: 'privilegedUserMonitoringDisabled',
  uiSettingRequired: _constants.ENABLE_PRIVILEGED_USER_MONITORING_SETTING,
  hideTimeline: false,
  skipUrlState: false,
  capabilities: [`${_constants.SECURITY_FEATURE_ID}.entity-analytics`],
  licenseType: 'platinum'
};
const eaOverviewLinks = {
  id: _constants.SecurityPageName.entityAnalyticsOverview,
  title: _i18n.i18n.translate('xpack.securitySolution.appLinks.entityAnalytics.overview', {
    defaultMessage: 'Overview'
  }),
  description: _i18n.i18n.translate('xpack.securitySolution.navigation.entityAnalytics.overview.description', {
    defaultMessage: 'Entity analytics, anomalies, and threats to narrow down the monitoring surface area.'
  }),
  landingImage: _ea_overview_page.default,
  path: _constants.ENTITY_ANALYTICS_OVERVIEW_PATH,
  globalSearchKeywords: [_i18n.i18n.translate('xpack.securitySolution.appLinks.entityAnalytics.overview', {
    defaultMessage: 'Overview'
  })],
  hideTimeline: false,
  skipUrlState: false,
  capabilities: [`${_constants.SECURITY_FEATURE_ID}.entity-analytics`],
  licenseType: 'platinum'
};
const entityAnalyticsLinks = exports.entityAnalyticsLinks = {
  id: _constants.SecurityPageName.entityAnalyticsLanding,
  title: _translations.ENTITY_ANALYTICS,
  path: _constants.ENTITY_ANALYTICS_LANDING_PATH,
  globalNavPosition: 7,
  globalSearchKeywords: [_i18n.i18n.translate('xpack.securitySolution.appLinks.entityAnalytics.landing', {
    defaultMessage: 'Entity analytics'
  })],
  links: [eaOverviewLinks, privMonLinks],
  hideTimeline: true,
  skipUrlState: true,
  hideWhenExperimentalKey: 'privilegedUserMonitoringDisabled',
  uiSettingRequired: _constants.ENABLE_PRIVILEGED_USER_MONITORING_SETTING,
  capabilities: [`${_constants.SECURITY_FEATURE_ID}.entity-analytics`],
  licenseType: 'platinum'
};