"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateIndexModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _api = require("../../../api/api");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
var IndexMode = /*#__PURE__*/function (IndexMode) {
  IndexMode["STANDARD"] = "standard";
  IndexMode["LOOKUP"] = "lookup";
  return IndexMode;
}(IndexMode || {});
const INDEX_NAME_LABEL = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.createIndex.indexNameLabel', {
  defaultMessage: 'Index name'
});
const INDEX_MODE_LABEL = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.createIndex.indexModeLabel', {
  defaultMessage: 'Index mode'
});
const INDEX_MODES = [{
  value: IndexMode.STANDARD,
  text: _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.createIndex.mode.standard', {
    defaultMessage: 'Standard'
  })
}, {
  value: IndexMode.LOOKUP,
  text: _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.createIndex.mode.lookup', {
    defaultMessage: 'Lookup'
  })
}];
const CreateIndexModal = ({
  onClose,
  onCreate
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const [indexName, setIndexName] = (0, _react.useState)('');
  const [indexMode, setIndexMode] = (0, _react.useState)(IndexMode.STANDARD);
  const [error, setError] = (0, _react.useState)(null);
  const {
    createPrivMonImportIndex
  } = (0, _api.useEntityAnalyticsRoutes)();
  const handleCreate = (0, _react.useCallback)(async () => {
    setError(null);
    const trimmedName = indexName.trim();
    try {
      await createPrivMonImportIndex({
        name: trimmedName,
        mode: indexMode
      });
      onCreate(trimmedName);
    } catch (err) {
      setError(_i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.createIndex.error', {
        defaultMessage: 'Error creating index: {error}',
        values: {
          error: err.body.message || err.message || 'Unknown error'
        }
      }));
    }
  }, [indexName, createPrivMonImportIndex, indexMode, onCreate]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onClose,
    maxWidth: "624px",
    "aria-labelledby": modalTitleId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.createIndex.title",
    defaultMessage: "Create index"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, error && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger"
  }, error), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.createIndex.description",
    defaultMessage: "Create an index to store your privileged users. After creating it, make sure to index documents with the {nameField} field using your preferred method.",
    values: {
      nameField: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'user.name')
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: INDEX_NAME_LABEL,
    fullWidth: true,
    error: !!error && !indexName.trim() ? error : undefined
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    value: indexName,
    onChange: e => setIndexName(e.target.value),
    "aria-label": INDEX_NAME_LABEL,
    "data-test-subj": "createIndexModalIndexName"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: INDEX_MODE_LABEL,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: INDEX_MODES,
    value: indexMode,
    onChange: e => setIndexMode(e.target.value),
    "aria-label": INDEX_MODE_LABEL,
    "data-test-subj": "createIndexModalIndexMode"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.createIndex.cancelButtonLabel",
    defaultMessage: "Cancel"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: handleCreate,
    fill: true,
    disabled: !indexName.trim(),
    "data-test-subj": "createIndexModalCreateButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.createIndex.createButtonLabel",
    defaultMessage: "Create index"
  })))))));
};
exports.CreateIndexModal = CreateIndexModal;