"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddDataSourcePanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _reactHooks = require("@kbn/react-hooks");
var _select_index_modal = require("./select_index_modal");
var _upload_privileged_users_modal = require("./file_uploader/upload_privileged_users_modal");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddDataSourcePanel = ({
  onComplete
}) => {
  const [isIndexModalOpen, {
    on: showIndexModal,
    off: hideIndexModal
  }] = (0, _reactHooks.useBoolean)(false);
  const [isImportFileModalVisible, setShowImportFileModal] = (0, _react.useState)(false);
  const closeImportFileModal = () => setShowImportFileModal(false);
  const showImportFileModal = () => setShowImportFileModal(true);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "xl",
    hasShadow: false,
    hasBorder: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.addDataSource.title",
    defaultMessage: "Add data source for your privileged users"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.addDataSource.description",
    defaultMessage: "To get started, define your privileged users by selecting an index with user data or importing your list of privileged users from a supported file."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    hasBorder: true,
    layout: "horizontal",
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "l",
      type: "indexOpen"
    }),
    titleSize: "xs",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.addDataSource.index.title",
      defaultMessage: "Index"
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.addDataSource.index.description",
      defaultMessage: "Select an index that contains relevant user activity data"
    }),
    onClick: showIndexModal
  }), isIndexModalOpen && /*#__PURE__*/_react.default.createElement(_select_index_modal.IndexSelectorModal, {
    onClose: hideIndexModal,
    onImport: onComplete
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    hasBorder: true,
    layout: "horizontal",
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "l",
      type: "importAction"
    }),
    titleSize: "xs",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.addDataSource.file.title",
      defaultMessage: "File"
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.addDataSource.file.description",
      defaultMessage: "Import a list of privileged users from a CSV file"
    }),
    onClick: showImportFileModal
  }))), isImportFileModalVisible && /*#__PURE__*/_react.default.createElement(_upload_privileged_users_modal.UploadPrivilegedUsersModal, {
    onClose: closeImportFileModal,
    onImport: onComplete
  }));
};
exports.AddDataSourcePanel = AddDataSourcePanel;