"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivilegedUserMonitoringManageDataSources = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _csv_upload_manage_data_source = require("./csv_upload_manage_data_source");
var _header_page = require("../../../common/components/header_page");
var _use_space_id = require("../../../common/hooks/use_space_id");
var _index_import_manage_data_source = require("./index_import_manage_data_source");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PrivilegedUserMonitoringManageDataSources = ({
  onBackToDashboardClicked
}) => {
  const spaceId = (0, _use_space_id.useSpaceId)();
  const [addDataSourceResult, setAddDataSourceResult] = (0, _react.useState)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    flush: "left",
    iconType: "arrowLeft",
    iconSide: "left",
    onClick: onBackToDashboardClicked
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.manageDataSources.back",
    defaultMessage: "Back to privileged user monitoring"
  })), /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    border: true,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.manageDataSources.title",
      defaultMessage: "Manage data sources"
    })
  }), (addDataSourceResult === null || addDataSourceResult === void 0 ? void 0 : addDataSourceResult.successful) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: addDataSourceResult.userCount > 0 ? _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.manageDataSources.successMessage', {
      defaultMessage: 'New data source of privileged users successfully set up: {userCount} users added',
      values: {
        userCount: addDataSourceResult.userCount
      }
    }) : _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.manageDataSources.successMessageWithoutUserCount', {
      defaultMessage: 'New data source of privileged users successfully set up'
    }),
    color: "success",
    iconType: "check"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), /*#__PURE__*/_react.default.createElement(_index_import_manage_data_source.IndexImportManageDataSource, {
    setAddDataSourceResult: setAddDataSourceResult
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), spaceId && /*#__PURE__*/_react.default.createElement(_csv_upload_manage_data_source.CsvUploadManageDataSource, {
    setAddDataSourceResult: setAddDataSourceResult,
    namespace: spaceId
  }));
};
exports.PrivilegedUserMonitoringManageDataSources = PrivilegedUserMonitoringManageDataSources;