"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EngineStatusHeader = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EngineStatusHeader = ({
  entityType,
  actionButton
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "row",
  gutterSize: "m",
  alignItems: "baseline",
  responsive: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.entityAnalytics.entityStore.enginesStatus.title",
  defaultMessage: "{type} Store",
  values: {
    type: (0, _fp.capitalize)(entityType)
  }
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  direction: "row"
}, actionButton))));
exports.EngineStatusHeader = EngineStatusHeader;