"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAlertsPrivileges = void 0;
var _react = require("react");
var _user_privileges = require("../../../../common/components/user_privileges");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook to get user privilege from
 *
 */
const useAlertsPrivileges = () => {
  const {
    detectionEnginePrivileges: {
      error,
      result,
      loading
    },
    kibanaSecuritySolutionsPrivileges: {
      crud: hasKibanaCRUD,
      read: hasKibanaREAD
    }
  } = (0, _user_privileges.useUserPrivileges)();
  const indexName = (0, _react.useMemo)(() => {
    if (result !== null && result !== void 0 && result.index && Object.keys(result.index).length > 0) {
      return Object.keys(result.index)[0];
    }
    return null;
  }, [result === null || result === void 0 ? void 0 : result.index]);
  const privileges = (0, _react.useMemo)(() => {
    if (error != null) {
      return {
        isAuthenticated: false,
        hasEncryptionKey: false,
        hasIndexManage: false,
        hasIndexRead: false,
        hasIndexWrite: false,
        hasIndexUpdateDelete: false,
        hasIndexMaintenance: false,
        hasKibanaCRUD,
        hasKibanaREAD
      };
    }
    if (result != null && indexName) {
      return {
        isAuthenticated: result.is_authenticated,
        hasEncryptionKey: result.has_encryption_key,
        hasIndexManage: result.index[indexName].manage && result.cluster.manage,
        hasIndexMaintenance: result.index[indexName].maintenance,
        hasIndexRead: result.index[indexName].read,
        hasIndexWrite: result.index[indexName].create || result.index[indexName].create_doc || result.index[indexName].index || result.index[indexName].write,
        hasIndexUpdateDelete: result.index[indexName].write,
        hasKibanaCRUD,
        hasKibanaREAD
      };
    }
    return {
      isAuthenticated: null,
      hasEncryptionKey: null,
      hasIndexManage: null,
      hasIndexRead: null,
      hasIndexWrite: null,
      hasIndexUpdateDelete: null,
      hasIndexMaintenance: null,
      hasKibanaCRUD: false,
      hasKibanaREAD: false
    };
  }, [error, result, indexName, hasKibanaCRUD, hasKibanaREAD]);
  return {
    loading: loading !== null && loading !== void 0 ? loading : false,
    ...privileges
  };
};
exports.useAlertsPrivileges = useAlertsPrivileges;