"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultGroupTitleRenderers = exports.RuleNameGroupContent = exports.RULE_NAME_GROUP_TITLE_TEST_ID = exports.RULE_NAME_GROUP_TEST_ID = exports.RULE_NAME_GROUP_TAG_TEST_ID = exports.RULE_NAME_GROUP_TAGS_TEST_ID = exports.RULE_NAME_GROUP_DESCRIPTION_TEST_ID = exports.GroupWithIconContent = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _ecs_safety_helpers = require("../../../../../common/endpoint/models/ecs_safety_helpers");
var _popover_items = require("../../../../common/components/popover_items");
var _translations = require("../../../../detection_engine/common/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns renderers to be used in the `buttonContent` property of the EuiAccordion component used within the kbn-grouping package.
 * It handles custom renders for the following fields:
 * - kibana.alert.rule.name
 * - host.name
 * - user.name
 * - source.ip
 * For all the other fields the default renderer managed within the kbn-grouping package will be used.
 *
 * This go hand in hand with defaultGroupingOptions and defaultGroupStatsRenderer and defaultGroupStatsAggregations.
 */
const defaultGroupTitleRenderers = (selectedGroup, bucket, nullGroupMessage) => {
  var _firstNonNullValue, _firstNonNullValue2, _bucket$description, _bucket$ruleTags;
  switch (selectedGroup) {
    case 'kibana.alert.rule.name':
      return (0, _fp.isArray)(bucket.key) ? /*#__PURE__*/_react.default.createElement(RuleNameGroupContent, {
        ruleName: bucket.key[0],
        ruleDescription: (_firstNonNullValue = (0, _ecs_safety_helpers.firstNonNullValue)((_firstNonNullValue2 = (0, _ecs_safety_helpers.firstNonNullValue)((_bucket$description = bucket.description) === null || _bucket$description === void 0 ? void 0 : _bucket$description.buckets)) === null || _firstNonNullValue2 === void 0 ? void 0 : _firstNonNullValue2.key)) !== null && _firstNonNullValue !== void 0 ? _firstNonNullValue : '',
        tags: (_bucket$ruleTags = bucket.ruleTags) === null || _bucket$ruleTags === void 0 ? void 0 : _bucket$ruleTags.buckets
      }) : undefined;
    case 'host.name':
      return /*#__PURE__*/_react.default.createElement(GroupWithIconContent, {
        title: bucket.key,
        icon: "storage",
        nullGroupMessage: nullGroupMessage,
        dataTestSubj: "host-name"
      });
    case 'user.name':
      return /*#__PURE__*/_react.default.createElement(GroupWithIconContent, {
        title: bucket.key,
        icon: "user",
        nullGroupMessage: nullGroupMessage,
        dataTestSubj: "user-name"
      });
    case 'source.ip':
      return /*#__PURE__*/_react.default.createElement(GroupWithIconContent, {
        title: bucket.key,
        icon: "globe",
        nullGroupMessage: nullGroupMessage,
        dataTestSubj: "source-ip"
      });
  }
};
exports.defaultGroupTitleRenderers = defaultGroupTitleRenderers;
const RULE_NAME_GROUP_TEST_ID = exports.RULE_NAME_GROUP_TEST_ID = 'rule-name-group-renderer';
const RULE_NAME_GROUP_TITLE_TEST_ID = exports.RULE_NAME_GROUP_TITLE_TEST_ID = 'rule-name-group-renderer-title';
const RULE_NAME_GROUP_DESCRIPTION_TEST_ID = exports.RULE_NAME_GROUP_DESCRIPTION_TEST_ID = 'rule-name-group-renderer-description';
const RULE_NAME_GROUP_TAG_TEST_ID = exports.RULE_NAME_GROUP_TAG_TEST_ID = 'rule-name-group-renderer-tag';
const RULE_NAME_GROUP_TAGS_TEST_ID = exports.RULE_NAME_GROUP_TAGS_TEST_ID = 'rule-name-group-renderer-tags';
const RuleNameGroupContent = exports.RuleNameGroupContent = /*#__PURE__*/_react.default.memo(({
  ruleName,
  ruleDescription,
  tags
}) => {
  const renderItem = (tag, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    key: `${tag}-${i}`,
    "data-test-subj": RULE_NAME_GROUP_TAG_TEST_ID
  }, tag);
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      display: 'table',
      tableLayout: 'fixed',
      width: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": RULE_NAME_GROUP_TEST_ID,
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      display: 'contents'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    "data-test-subj": RULE_NAME_GROUP_TITLE_TEST_ID,
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h5", {
    className: "eui-textTruncate"
  }, ruleName.trim()))), tags && tags.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_popover_items.PopoverItems, {
    items: tags.map(tag => tag.key.toString()),
    popoverTitle: _translations.COLUMN_TAGS,
    popoverButtonTitle: tags.length.toString(),
    popoverButtonIcon: "tag",
    dataTestPrefix: RULE_NAME_GROUP_TAGS_TEST_ID,
    renderItem: renderItem
  })) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": RULE_NAME_GROUP_DESCRIPTION_TEST_ID,
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", {
    className: "eui-textTruncate"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, ruleDescription))));
});
RuleNameGroupContent.displayName = 'RuleNameGroup';
const GroupWithIconContent = exports.GroupWithIconContent = /*#__PURE__*/_react.default.memo(({
  title,
  icon,
  nullGroupMessage,
  dataTestSubj
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  "data-test-subj": `${dataTestSubj}-group-renderer`,
  gutterSize: "s",
  alignItems: "center"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
  "data-test-subj": `${dataTestSubj}-group-renderer-icon`,
  size: "m",
  type: icon
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  "data-test-subj": `${dataTestSubj}-group-renderer-title`,
  size: "xs"
}, /*#__PURE__*/_react.default.createElement("h5", null, title))), nullGroupMessage && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  "data-test-subj": `${dataTestSubj}-group-renderer-null-message`,
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
  content: nullGroupMessage,
  position: "right"
}))));
GroupWithIconContent.displayName = 'GroupWithIconContent';