"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Wrapper = exports.SKELETON_TEST_ID = exports.DATA_VIEW_LOADING_PROMPT_TEST_ID = exports.DATA_VIEW_ERROR_TEST_ID = exports.CONTENT_TEST_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_data_view = require("../../../data_view_manager/hooks/use_data_view");
var _kpis_section = require("./kpis/kpis_section");
var _integration_section = require("./integrations/integration_section");
var _search_bar_section = require("./search_bar/search_bar_section");
var _table_section = require("./table/table_section");
var _use_create_data_view = require("../../../common/hooks/use_create_data_view");
var _model = require("../../../sourcerer/store/model");
var _use_experimental_features = require("../../../common/hooks/use_experimental_features");
var _use_space_id = require("../../../common/hooks/use_space_id");
var _constants = require("../../../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DATAVIEW_ERROR = _i18n.i18n.translate('xpack.securitySolution.alertSummary.dataViewError', {
  defaultMessage: 'Unable to create data view'
});
const DATA_VIEW_LOADING_PROMPT_TEST_ID = exports.DATA_VIEW_LOADING_PROMPT_TEST_ID = 'alert-summary-data-view-loading-prompt';
const DATA_VIEW_ERROR_TEST_ID = exports.DATA_VIEW_ERROR_TEST_ID = 'alert-summary-data-view-error';
const SKELETON_TEST_ID = exports.SKELETON_TEST_ID = 'alert-summary-skeleton';
const CONTENT_TEST_ID = exports.CONTENT_TEST_ID = 'alert-summary-content';
/**
 * Creates a new adhoc dataView for the alert summary page. The dataView is created just with the alert indices.
 * During the creating, we display a loading skeleton, mimicking the future alert summary page content.
 * Once the dataView is correctly created, we render the content.
 * If the creation fails, we show an error message.
 */
const Wrapper = exports.Wrapper = /*#__PURE__*/(0, _react.memo)(({
  packages,
  ruleResponse
}) => {
  var _experimentalDataView;
  const spaceId = (0, _use_space_id.useSpaceId)();
  const oldSignalIndexName = `${_constants.DEFAULT_ALERTS_INDEX}-${spaceId}`;
  const dataViewSpec = (0, _react.useMemo)(() => ({
    title: oldSignalIndexName
  }), [oldSignalIndexName]);
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    dataView: oldDataView,
    loading: oldDataViewLoading
  } = (0, _use_create_data_view.useCreateDataView)({
    dataViewSpec,
    skip: newDataViewPickerEnabled // skip data view creation if the new data view picker is enabled
  });
  const {
    dataView: experimentalDataView,
    status
  } = (0, _use_data_view.useDataView)(_model.SourcererScopeName.detections);
  const signalIndexName = newDataViewPickerEnabled ? (_experimentalDataView = experimentalDataView === null || experimentalDataView === void 0 ? void 0 : experimentalDataView.getIndexPattern()) !== null && _experimentalDataView !== void 0 ? _experimentalDataView : '' : oldSignalIndexName;
  const loading = newDataViewPickerEnabled ? status !== 'ready' : oldDataViewLoading;
  const dataView = newDataViewPickerEnabled ? experimentalDataView : oldDataView;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonLoading, {
    "data-test-subj": DATA_VIEW_LOADING_PROMPT_TEST_ID,
    isLoading: loading,
    loadingContent: /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": SKELETON_TEST_ID
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
      height: 50,
      width: "100%"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
      height: 50,
      width: "100%"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
      height: 275,
      width: "100%"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
      height: 600,
      width: "100%"
    })),
    loadedContent: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !dataView || !dataView.id ? /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      color: "danger",
      "data-test-subj": DATA_VIEW_ERROR_TEST_ID,
      iconType: "error",
      title: /*#__PURE__*/_react.default.createElement("h2", null, DATAVIEW_ERROR)
    }) : /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": CONTENT_TEST_ID
    }, /*#__PURE__*/_react.default.createElement(_integration_section.IntegrationSection, {
      packages: packages
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_search_bar_section.SearchBarSection, {
      dataView: dataView,
      packages: packages,
      ruleResponse: ruleResponse
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_kpis_section.KPIsSection, {
      signalIndexName: signalIndexName
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_table_section.TableSection, {
      dataView: dataView,
      packages: packages,
      ruleResponse: ruleResponse
    })))
  });
});
Wrapper.displayName = 'Wrapper';