"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.groupTitleRenderers = exports.SIGNAL_RULE_ID_GROUP_RENDERER_TEST_ID = exports.IntegrationNameGroupContent = exports.INTEGRATION_GROUP_RENDERER_TEST_ID = exports.INTEGRATION_GROUP_RENDERER_LOADING_TEST_ID = exports.INTEGRATION_GROUP_RENDERER_INTEGRATION_NAME_TEST_ID = exports.INTEGRATION_GROUP_RENDERER_INTEGRATION_ICON_TEST_ID = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _integration_icon = require("../common/integration_icon");
var _table_section_context = require("./table_section_context");
var _use_get_integration_from_rule_id = require("../../../hooks/alert_summary/use_get_integration_from_rule_id");
var _grouping_settings = require("../../alerts_table/grouping_settings");
var _ecs_safety_helpers = require("../../../../../common/endpoint/models/ecs_safety_helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns renderers to be used in the `buttonContent` property of the EuiAccordion component used within the kbn-grouping package.
 * It handles custom renders for the following fields:
 * - signal.rule.rule_id
 * - kibana.alert.rule.name
 * - host.name
 * - user.name
 * - source.ip
 * For all the other fields the default renderer managed within the kbn-grouping package will be used.
 *
 * These go hand in hand with groupingOptions, groupStatsRenderer and groupStatsAggregations.
 */
const groupTitleRenderers = (selectedGroup, bucket, nullGroupMessage) => {
  var _firstNonNullValue, _firstNonNullValue2, _bucket$description, _bucket$ruleTags;
  switch (selectedGroup) {
    case 'signal.rule.rule_id':
      return /*#__PURE__*/_react.default.createElement(IntegrationNameGroupContent, {
        title: bucket.key
      });
    case 'kibana.alert.rule.name':
      return (0, _fp.isArray)(bucket.key) ? /*#__PURE__*/_react.default.createElement(_grouping_settings.RuleNameGroupContent, {
        ruleName: bucket.key[0],
        ruleDescription: (_firstNonNullValue = (0, _ecs_safety_helpers.firstNonNullValue)((_firstNonNullValue2 = (0, _ecs_safety_helpers.firstNonNullValue)((_bucket$description = bucket.description) === null || _bucket$description === void 0 ? void 0 : _bucket$description.buckets)) === null || _firstNonNullValue2 === void 0 ? void 0 : _firstNonNullValue2.key)) !== null && _firstNonNullValue !== void 0 ? _firstNonNullValue : '',
        tags: (_bucket$ruleTags = bucket.ruleTags) === null || _bucket$ruleTags === void 0 ? void 0 : _bucket$ruleTags.buckets
      }) : undefined;
    case 'host.name':
      return /*#__PURE__*/_react.default.createElement(_grouping_settings.GroupWithIconContent, {
        title: bucket.key,
        icon: "storage",
        nullGroupMessage: nullGroupMessage,
        dataTestSubj: "host-name"
      });
    case 'user.name':
      return /*#__PURE__*/_react.default.createElement(_grouping_settings.GroupWithIconContent, {
        title: bucket.key,
        icon: "user",
        nullGroupMessage: nullGroupMessage,
        dataTestSubj: "user-name"
      });
    case 'source.ip':
      return /*#__PURE__*/_react.default.createElement(_grouping_settings.GroupWithIconContent, {
        title: bucket.key,
        icon: "globe",
        nullGroupMessage: nullGroupMessage,
        dataTestSubj: "source-ip"
      });
  }
};
exports.groupTitleRenderers = groupTitleRenderers;
const INTEGRATION_GROUP_RENDERER_LOADING_TEST_ID = exports.INTEGRATION_GROUP_RENDERER_LOADING_TEST_ID = 'integration-group-renderer-loading';
const INTEGRATION_GROUP_RENDERER_TEST_ID = exports.INTEGRATION_GROUP_RENDERER_TEST_ID = 'integration-group-renderer';
const INTEGRATION_GROUP_RENDERER_INTEGRATION_NAME_TEST_ID = exports.INTEGRATION_GROUP_RENDERER_INTEGRATION_NAME_TEST_ID = 'integration-group-renderer-integration-name';
const INTEGRATION_GROUP_RENDERER_INTEGRATION_ICON_TEST_ID = exports.INTEGRATION_GROUP_RENDERER_INTEGRATION_ICON_TEST_ID = 'integration-group-renderer';
const SIGNAL_RULE_ID_GROUP_RENDERER_TEST_ID = exports.SIGNAL_RULE_ID_GROUP_RENDERER_TEST_ID = 'signal-rule-id-group-renderer';

/**
 * Renders an icon and name of an integration.
 * This component needs to be used within the TableSectionContext which provides the installed packages as well as all the rules.
 */
const IntegrationNameGroupContent = exports.IntegrationNameGroupContent = /*#__PURE__*/(0, _react.memo)(({
  title
}) => {
  const {
    packages,
    ruleResponse
  } = (0, _table_section_context.useTableSectionContext)();
  const {
    integration
  } = (0, _use_get_integration_from_rule_id.useGetIntegrationFromRuleId)({
    packages,
    ruleId: title,
    rules: ruleResponse.rules
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    "data-test-subj": INTEGRATION_GROUP_RENDERER_LOADING_TEST_ID,
    isLoading: ruleResponse.isLoading,
    lines: 1
  }, integration ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": INTEGRATION_GROUP_RENDERER_TEST_ID,
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_integration_icon.IntegrationIcon, {
    "data-test-subj": INTEGRATION_GROUP_RENDERER_INTEGRATION_ICON_TEST_ID,
    iconSize: "xl",
    integration: integration
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    "data-test-subj": INTEGRATION_GROUP_RENDERER_INTEGRATION_NAME_TEST_ID,
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, integration.title)))) : /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    "data-test-subj": SIGNAL_RULE_ID_GROUP_RENDERER_TEST_ID,
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, title)));
});
IntegrationNameGroupContent.displayName = 'IntegrationNameGroup';