"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlRuleWarningPopover = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _rule_monitoring = require("../../../../../common/api/detection_engine/rule_monitoring");
var i18n = _interopRequireWildcard(require("../rules_table/translations"));
var _use_bool_state = require("../../../../common/hooks/use_bool_state");
var _redirect_to_detection_engine = require("../../../../common/components/link_to/redirect_to_detection_engine");
var _constants = require("../../../../../common/constants");
var _links = require("../../../../common/components/links");
var _utils = require("../../../../../common/detection_engine/utils");
var _utils2 = require("../../../common/components/rule_execution_status/utils");
var _helpers = require("../../../../../common/machine_learning/helpers");
var _use_rule_details_tabs = require("../../../rule_details_ui/pages/rule_details/use_rule_details_tabs");
var _helpers2 = require("../../../common/helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const POPOVER_WIDTH = '340px';
const MlRuleWarningPopoverComponent = ({
  rule,
  loadingJobs,
  jobs
}) => {
  const [isPopoverOpen,, closePopover, togglePopover] = (0, _use_bool_state.useBoolState)();
  const jobIds = (0, _helpers2.getMachineLearningJobId)(rule);
  if (!(0, _utils.isMlRule)(rule.type) || loadingJobs || !jobIds) {
    return null;
  }
  const notRunningJobs = jobs.filter(job => jobIds.includes(job.id) && !(0, _helpers.isJobStarted)(job.jobState, job.datafeedState));
  if (!notRunningJobs.length) {
    return null;
  }
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    display: 'empty',
    color: 'warning',
    iconType: 'warning',
    onClick: togglePopover
  });
  const popoverTitle = (0, _utils2.getCapitalizedStatusText)(_rule_monitoring.RuleExecutionStatusEnum['partial failure']);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    anchorPosition: "leftCenter"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, popoverTitle), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: POPOVER_WIDTH
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, i18n.ML_RULE_JOBS_WARNING_DESCRIPTION))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), notRunningJobs.map(job => {
    var _job$customSettings$s, _job$customSettings;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      key: job.id
    }, (_job$customSettings$s = (_job$customSettings = job.customSettings) === null || _job$customSettings === void 0 ? void 0 : _job$customSettings.security_app_display_name) !== null && _job$customSettings$s !== void 0 ? _job$customSettings$s : job.id);
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, null, /*#__PURE__*/_react.default.createElement(_links.SecuritySolutionLinkButton, {
    "data-test-subj": "open-rule-details",
    fullWidth: true,
    deepLinkId: _constants.SecurityPageName.rules,
    path: (0, _redirect_to_detection_engine.getRuleDetailsTabUrl)(rule.id, _use_rule_details_tabs.RuleDetailTabs.alerts)
  }, i18n.ML_RULE_JOBS_WARNING_BUTTON_LABEL)));
};
const MlRuleWarningPopover = exports.MlRuleWarningPopover = /*#__PURE__*/_react.default.memo(MlRuleWarningPopoverComponent);
MlRuleWarningPopover.displayName = 'MlRuleWarningPopover';